/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.ContactTest;
import com.openexchange.ajax.ResourceTest;
import com.openexchange.ajax.appointment.action.ListRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.ajax.group.GroupTest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.webdav.xml.FolderTest;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;

public class ListTest
extends AppointmentTest {
    private static final Log LOG = LogFactory.getLog(ListTest.class);

    public ListTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testList() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testList");
        appointmentObj.setIgnoreConflicts(true);
        int id1 = ListTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        int id2 = ListTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        int id3 = ListTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        int[][] objectIdAndFolderId = new int[][]{{id1, appointmentFolderId}, {id2, appointmentFolderId}, {id3, appointmentFolderId}};
        int[] cols = new int[]{1, 200, 2, 20, 221};
        Appointment[] appointmentArray = ListTest.listAppointment(this.getWebConversation(), objectIdAndFolderId, cols, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        ListTest.assertEquals((String)"check response array", (int)3, (int)appointmentArray.length);
        ListTest.deleteAppointment(this.getWebConversation(), id1, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
        ListTest.deleteAppointment(this.getWebConversation(), id2, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
        ListTest.deleteAppointment(this.getWebConversation(), id3, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testListWithNoEntries() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testList");
        appointmentObj.setIgnoreConflicts(true);
        int id1 = ListTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        int id2 = ListTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        int id3 = ListTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        int[][] objectIdAndFolderId = new int[][]{};
        int[] cols = new int[]{1, 200, 2, 20, 221};
        Appointment[] appointmentArray = ListTest.listAppointment(this.getWebConversation(), objectIdAndFolderId, cols, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        ListTest.assertEquals((String)"check response array", (int)0, (int)appointmentArray.length);
        ListTest.deleteAppointment(this.getWebConversation(), id1, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
        ListTest.deleteAppointment(this.getWebConversation(), id2, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
        ListTest.deleteAppointment(this.getWebConversation(), id3, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListWithAllFields() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testListWithAllFields");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setLocation("Location");
        appointmentObj.setShownAs(4);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setFullTime(true);
        appointmentObj.setLabel(2);
        appointmentObj.setNote("note");
        appointmentObj.setCategories("testcat1,testcat2,testcat3");
        appointmentObj.setOrganizer("someone else");
        appointmentObj.setUid("1234567890abcdef");
        appointmentObj.setSequence(0);
        int userParticipantId = ContactTest.searchContact(this.getWebConversation(), this.userParticipant3, 6, new int[]{524}, "http://" + this.getHostName(), this.getSessionId())[0].getInternalUserId();
        int groupParticipantId = GroupTest.searchGroup(this.getWebConversation(), this.groupParticipant, "http://", this.getHostName(), this.getSessionId())[0].getIdentifier();
        int resourceParticipantId = ResourceTest.searchResource(this.getWebConversation(), this.resourceParticipant, "http://" + this.getHostName(), this.getSessionId())[0].getIdentifier();
        Participant[] participants = new Participant[]{new UserParticipant(this.userId), new UserParticipant(userParticipantId), new GroupParticipant(groupParticipantId), new ResourceParticipant(resourceParticipantId)};
        appointmentObj.setParticipants(participants);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = 0;
        try {
            objectId = ListTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
            int[][] objectIdAndFolderId = new int[][]{{objectId, appointmentFolderId}};
            Appointment[] appointmentArray = ListTest.listAppointment(this.getWebConversation(), objectIdAndFolderId, APPOINTMENT_FIELDS, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
            ListTest.assertEquals((String)"check response array", (int)1, (int)appointmentArray.length);
            Appointment loadAppointment = appointmentArray[0];
            Calendar c = Calendar.getInstance();
            c.setTimeZone(TimeZone.getTimeZone("UTC"));
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            long newStartTime = c.getTimeInMillis();
            long newEndTime = newStartTime + 86400000L;
            appointmentObj.setObjectID(objectId);
            appointmentObj.setParentFolderID(appointmentFolderId);
            this.compareObject(appointmentObj, loadAppointment, newStartTime, newEndTime);
        }
        catch (OXException exc) {
            LOG.warn((Object)("Conflict Exception found. Maybe test result is wrong: " + (Object)((Object)exc)));
        }
        finally {
            if (objectId != 0) {
                ListTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
            }
        }
    }

    public void testListWithRecurrencePosition() throws Exception {
        int[] cols = new int[]{1, 200, 2, 20, 221, 207};
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testListWithRecurrencePosition" + System.currentTimeMillis());
        folderObj.setParentFolderID(2);
        folderObj.setModule(2);
        folderObj.setType(2);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 128, 128, 128, 128)};
        folderObj.setPermissionsAsArray(permission);
        int publicFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, this.getHostName(), this.getLogin(), this.getPassword(), "");
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date until = new Date(c.getTimeInMillis() + 1296000000L);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testListWithRecurrencePosition");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(publicFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId1 = ListTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj = new Appointment();
        appointmentObj.setTitle("testListWithRecurrencePosition2");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setParentFolderID(appointmentFolderId);
        int objectId2 = ListTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        Appointment[] appointmentList = new Appointment[3];
        appointmentList[0] = new Appointment();
        appointmentList[0].setObjectID(objectId1);
        appointmentList[0].setParentFolderID(publicFolderId);
        appointmentList[0].setRecurrencePosition(2);
        appointmentList[1] = new Appointment();
        appointmentList[1].setObjectID(objectId1);
        appointmentList[1].setParentFolderID(publicFolderId);
        appointmentList[1].setRecurrencePosition(3);
        appointmentList[2] = new Appointment();
        appointmentList[2].setObjectID(objectId2);
        appointmentList[2].setParentFolderID(appointmentFolderId);
        Appointment[] appointmentArray = AppointmentTest.listAppointment(this.getWebConversation(), appointmentList, cols, this.timeZone, this.getHostName(), this.getSessionId());
        ListTest.assertEquals((String)"3 elements expected", (int)3, (int)appointmentArray.length);
        boolean found1 = false;
        boolean found2 = false;
        boolean found3 = false;
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() == objectId1 && appointmentArray[a].getRecurrencePosition() == 2) {
                found1 = true;
                continue;
            }
            if (appointmentArray[a].getObjectID() == objectId1 && appointmentArray[a].getRecurrencePosition() == 3) {
                found2 = true;
                continue;
            }
            if (appointmentArray[a].getObjectID() != objectId2) continue;
            found3 = true;
        }
        ListTest.assertTrue((String)("not all objects in response : " + found1 + ":" + found2 + ":" + found3), (found1 && found2 && found3 ? 1 : 0) != 0);
        ListTest.deleteAppointment(this.getWebConversation(), objectId1, publicFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
        ListTest.deleteAppointment(this.getWebConversation(), objectId2, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLastModifiedUTC() throws Exception {
        AJAXClient client = new AJAXClient(new AJAXSession(this.getWebConversation(), this.getHostName(), this.getSessionId()), false);
        int[] cols = new int[]{1, 20, 6};
        Appointment appointmentObj = this.createAppointmentObject("testShowLastModifiedUTC");
        appointmentObj.setStartDate(new Date());
        appointmentObj.setEndDate(new Date(System.currentTimeMillis() + 3600000L));
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ListTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, this.getHostName(), this.getSessionId());
        try {
            ListRequest listRequest = new ListRequest(ListIDs.l(new int[][]{{appointmentFolderId, objectId}}), cols, true);
            CommonListResponse response = Executor.execute(client, listRequest);
            JSONArray arr = (JSONArray)response.getResponse().getData();
            ListTest.assertNotNull((Object)arr);
            int size = arr.length();
            ListTest.assertTrue((size > 0 ? 1 : 0) != 0);
            for (int i = 0; i < size; ++i) {
                JSONArray objectData = arr.optJSONArray(i);
                ListTest.assertNotNull((Object)objectData);
                ListTest.assertNotNull((Object)objectData.opt(2));
            }
        }
        finally {
            ListTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.getHostName(), this.getSessionId(), false);
        }
    }
}

