/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.AbstractAJAXTest;
import com.openexchange.ajax.FolderTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.parser.ResponseParser;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class InfostoreAJAXTest
extends AbstractAJAXTest {
    protected static final int[] virtualFolders = new int[]{9, 14, 15, 10};
    public static final String INFOSTORE_FOLDER = "infostore.folder";
    protected int folderId;
    protected String sessionId;
    protected List<Integer> clean = new ArrayList<Integer>();
    protected String hostName = null;

    public InfostoreAJAXTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.sessionId = this.getSessionId();
        int userId = FolderTest.getUserId(this.getWebConversation(), this.getHostName(), this.getLogin(), this.getPassword());
        this.folderId = this.createFolderForTest(userId);
        Map<String, String> create = this.m("folder_id", Integer.valueOf(this.folderId).toString(), "title", "test knowledge", "description", "test knowledge description");
        int c = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, create);
        this.clean.add(c);
        create = this.m("folder_id", Integer.valueOf(this.folderId).toString(), "title", "test url", "description", "test url description", "url", "http://www.open-xchange.com");
        c = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, create);
        this.clean.add(c);
    }

    private int createFolderForTest(int userId) throws JSONException, OXException, IOException, SAXException, OXException, OXException {
        int parent = FolderTest.getMyInfostoreFolder(this.getWebConversation(), this.getHostName(), this.sessionId, userId).getObjectID();
        return FolderTest.insertFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), userId, false, parent, "NewInfostoreFolder" + System.currentTimeMillis(), "infostore", 2, -1, true);
    }

    @Override
    public void tearDown() throws Exception {
        try {
            this.removeDocumentsAndFolders();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logout();
    }

    protected void removeDocumentsAndFolders() throws JSONException, IOException, SAXException {
        this.removeAll();
        FolderTest.deleteFolders(this.getWebConversation(), this.getHostName(), this.sessionId, new int[]{this.folderId}, Long.MAX_VALUE, false);
    }

    protected void removeDocumentsInFolder(int folderId) throws JSONException, IOException, SAXException {
        FolderTest.clearFolder(this.getWebConversation(), this.getHostName(), this.sessionId, new int[]{folderId}, Long.MAX_VALUE);
    }

    public void removeAll() throws JSONException, IOException, SAXException {
        int[][] toDelete = new int[this.clean.size()][2];
        for (int i = 0; i < toDelete.length; ++i) {
            toDelete[i][0] = this.folderId;
            toDelete[i][1] = this.clean.get(i);
        }
        this.delete(this.getWebConversation(), this.getHostName(), this.sessionId, Long.MAX_VALUE, toDelete);
        this.clean.clear();
    }

    private String j(int[] ids) {
        StringBuffer b = new StringBuffer("[ ");
        for (int i : ids) {
            b.append(i);
            b.append(' ');
        }
        b.append(']');
        return b.toString();
    }

    public Response all(WebConversation webConv, String hostname, String sessionId, int folderId, int[] columns) throws MalformedURLException, JSONException, IOException, SAXException {
        return this.all(webConv, hostname, sessionId, folderId, columns, -1, null);
    }

    public Response all(WebConversation webConv, String protocol, String hostname, String sessionId, int folderId, int[] columns, int sort, String order) throws MalformedURLException, JSONException, IOException, SAXException {
        StringBuffer url = this.getUrl(sessionId, "all", hostname, protocol);
        url.append("&folder=");
        url.append(folderId);
        url.append("&columns=");
        for (int col : columns) {
            url.append(col);
            url.append(',');
        }
        url.deleteCharAt(url.length() - 1);
        if (sort != -1) {
            url.append("&sort=");
            url.append(sort);
        }
        if (order != null) {
            url.append("&order=");
            url.append(order);
        }
        return this.gT(webConv, url.toString());
    }

    public Response all(WebConversation webConv, String hostname, String sessionId, int folderId, int[] columns, int sort, String order) throws MalformedURLException, JSONException, IOException, SAXException {
        return this.all(webConv, null, hostname, sessionId, folderId, columns, sort, order);
    }

    public Response list(WebConversation webConv, String hostname, String sessionId, int[] columns, int[][] ids) throws MalformedURLException, JSONException, IOException, SAXException {
        StringBuffer url = this.getUrl(sessionId, "list", hostname);
        url.append("&columns=");
        for (int col : columns) {
            url.append(col);
            url.append(',');
        }
        url.deleteCharAt(url.length() - 1);
        StringBuffer data = new StringBuffer("[");
        if (ids.length > 0) {
            for (int[] tuple : ids) {
                data.append("{folder : ");
                data.append(tuple[0]);
                data.append(", id : ");
                data.append(tuple[1]);
                data.append("},");
            }
            data.deleteCharAt(data.length() - 1);
        }
        data.append(']');
        return this.putT(webConv, url.toString(), data.toString());
    }

    public Response updates(WebConversation webConv, String hostname, String sessionId, int folderId, int[] columns, long timestamp) throws MalformedURLException, JSONException, IOException, SAXException {
        return this.updates(webConv, hostname, sessionId, folderId, columns, timestamp, -1, null, null);
    }

    public Response updates(WebConversation webConv, String hostname, String sessionId, int folderId, int[] columns, long timestamp, String ignore) throws MalformedURLException, JSONException, IOException, SAXException {
        return this.updates(webConv, hostname, sessionId, folderId, columns, timestamp, -1, null, ignore);
    }

    public Response updates(WebConversation webConv, String hostname, String sessionId, int folderId, int[] columns, long timestamp, int sort, String order, String ignore) throws MalformedURLException, JSONException, IOException, SAXException {
        StringBuffer url = this.getUrl(sessionId, "updates", hostname);
        url.append("&folder=");
        url.append(folderId);
        url.append("&columns=");
        for (int col : columns) {
            url.append(col);
            url.append(',');
        }
        url.deleteCharAt(url.length() - 1);
        url.append("&timestamp=");
        url.append(timestamp);
        if (sort != -1) {
            url.append("&sort=");
            url.append(sort);
        }
        if (order != null) {
            url.append("&order=");
            url.append(order);
        }
        if (ignore != null) {
            url.append("&ignore=");
            url.append(ignore);
        }
        return this.gT(webConv, url.toString());
    }

    public Response get(WebConversation webConv, String hostname, String sessionId, int objectId) throws MalformedURLException, JSONException, IOException, SAXException {
        return this.get(webConv, hostname, sessionId, objectId, -1);
    }

    public Response get(WebConversation webConv, String hostname, String sessionId, int objectId, int version) throws MalformedURLException, JSONException, IOException, SAXException {
        StringBuffer url = this.getUrl(sessionId, "get", hostname);
        url.append("&id=");
        url.append(objectId);
        if (version != -1) {
            url.append("&version=");
            url.append(version);
        }
        return this.gT(webConv, url.toString());
    }

    public Response versions(WebConversation webConv, String hostname, String sessionId, int objectId, int[] columns) throws MalformedURLException, JSONException, IOException, SAXException {
        return this.versions(webConv, hostname, sessionId, objectId, columns, -1, null);
    }

    public Response versions(WebConversation webConv, String hostname, String sessionId, int objectId, int[] columns, int sort, String order) throws MalformedURLException, JSONException, IOException, SAXException {
        StringBuffer url = this.getUrl(sessionId, "versions", hostname);
        url.append("&id=");
        url.append(objectId);
        url.append("&columns=");
        for (int col : columns) {
            url.append(col);
            url.append(',');
        }
        url.deleteCharAt(url.length() - 1);
        if (sort != -1) {
            url.append("&sort=");
            url.append(sort);
        }
        if (order != null) {
            url.append("&order=");
            url.append(order);
        }
        return this.gT(webConv, url.toString());
    }

    private JSONObject toJSONArgs(Map<String, String> modified) throws JSONException {
        JSONObject obj = new JSONObject();
        for (String attr : modified.keySet()) {
            obj.put(attr, (Object)modified.get(attr));
        }
        return obj;
    }

    public Response update(WebConversation webConv, String hostname, String sessionId, int id, long timestamp, Map<String, String> modified) throws MalformedURLException, IOException, SAXException, JSONException {
        StringBuffer url = this.getUrl(sessionId, "update", hostname);
        url.append("&id=");
        url.append(id);
        url.append("&timestamp=");
        url.append(timestamp);
        JSONObject obj = this.toJSONArgs(modified);
        return this.putT(webConv, url.toString(), obj.toString());
    }

    public Response update(WebConversation webConv, String hostname, String sessionId, int id, long timestamp, Map<String, String> modified, File upload, String contentType) throws MalformedURLException, IOException, SAXException, JSONException {
        StringBuffer url = this.getUrl(sessionId, "update", hostname);
        url.append("&id=");
        url.append(id);
        url.append("&timestamp=");
        url.append(timestamp);
        PostMethodWebRequest req = new PostMethodWebRequest(url.toString(), true);
        JSONObject obj = this.toJSONArgs(modified);
        req.setParameter("json", obj.toString());
        if (upload != null) {
            req.selectFile("file", upload, contentType);
        }
        WebResponse resp = webConv.getResource((WebRequest)req);
        JSONObject res = InfostoreAJAXTest.extractFromCallback(resp.getText());
        return Response.parse((String)res.toString());
    }

    public int createNew(WebConversation webConv, String protocol, String hostname, String sessionId, Map<String, String> fields) throws MalformedURLException, IOException, SAXException, JSONException {
        StringBuffer url = this.getUrl(sessionId, "new", hostname, protocol);
        JSONObject obj = this.toJSONArgs(fields);
        PutMethodWebRequest m = new PutMethodWebRequest(url.toString(), (InputStream)new ByteArrayInputStream(obj.toString().getBytes(Charsets.UTF_8)), "text/javascript");
        WebResponse resp = webConv.getResponse((WebRequest)m);
        try {
            return new JSONObject(resp.getText()).getInt("data");
        }
        catch (JSONException x) {
            throw new JSONException("Got unexpected answer: " + resp.getText());
        }
    }

    public int createNew(WebConversation webConv, String hostname, String sessionId, Map<String, String> fields) throws MalformedURLException, IOException, SAXException, JSONException {
        return this.createNew(webConv, null, hostname, sessionId, fields);
    }

    public int createNew(WebConversation webConv, String hostname, String sessionId, Map<String, String> fields, File upload, String contentType) throws MalformedURLException, IOException, SAXException, JSONException {
        return this.createNew(webConv, null, hostname, sessionId, fields, upload, contentType);
    }

    public int createNew(WebConversation webConv, String protocol, String hostname, String sessionId, Map<String, String> fields, File upload, String contentType) throws MalformedURLException, IOException, SAXException, JSONException {
        WebResponse resp;
        String html;
        JSONObject response;
        StringBuffer url = this.getUrl(sessionId, "new", hostname, protocol);
        PostMethodWebRequest req = new PostMethodWebRequest(url.toString(), true);
        JSONObject obj = this.toJSONArgs(fields);
        req.setParameter("json", obj.toString());
        if (upload != null) {
            req.selectFile("file", upload, contentType);
        }
        if ((response = InfostoreAJAXTest.extractFromCallback(html = (resp = webConv.getResource((WebRequest)req)).getText())) == null) {
            throw new IOException("Didn't receive response");
        }
        Response respO = ResponseParser.parse((JSONObject)response);
        if (respO.hasError()) {
            throw new IOException(respO.getErrorMessage());
        }
        if (!"".equals(response.optString("error"))) {
            // empty if block
        }
        try {
            return response.getInt("data");
        }
        catch (JSONException x) {
            throw new JSONException("Got unexpected answer: " + response);
        }
    }

    public int saveAs(WebConversation webConv, String hostname, String sessionId, int folderId, int attached, int module, int attachment, Map<String, String> fields) throws MalformedURLException, IOException, SAXException, JSONException {
        StringBuffer url = this.getUrl(sessionId, "saveAs", hostname);
        url.append("&folder=");
        url.append(folderId);
        url.append("&attached=");
        url.append(attached);
        url.append("&module=");
        url.append(module);
        url.append("&attachment=");
        url.append(attachment);
        JSONObject obj = this.toJSONArgs(fields);
        PutMethodWebRequest m = new PutMethodWebRequest(url.toString(), (InputStream)new ByteArrayInputStream(obj.toString().getBytes()), "text/javascript");
        WebResponse resp = webConv.getResponse((WebRequest)m);
        Response res = Response.parse((String)resp.getText());
        if (res.hasError()) {
            throw new JSONException(res.getErrorMessage());
        }
        return Integer.parseInt(res.getData().toString());
    }

    public int[] delete(WebConversation webConv, String protocol, String hostname, String sessionId, long timestamp, int[][] ids) throws MalformedURLException, JSONException, IOException, SAXException {
        int[][] notDeletedTuple = this.deleteFromFolders(webConv, protocol, hostname, sessionId, timestamp, ids);
        int[] retval = new int[notDeletedTuple.length];
        int i = 0;
        for (int[] tuple : notDeletedTuple) {
            retval[i++] = tuple[0];
        }
        return retval;
    }

    public int[] delete(WebConversation webConv, String hostname, String sessionId, long timestamp, int[][] ids) throws MalformedURLException, JSONException, IOException, SAXException {
        return this.delete(webConv, null, hostname, sessionId, timestamp, ids);
    }

    public int[][] deleteFromFolders(WebConversation webConv, String protocol, String hostname, String sessionId, long timestamp, int[][] ids) throws JSONException, IOException, SAXException {
        JSONObject response = this.deleteGetResponse(webConv, protocol, hostname, sessionId, timestamp, ids);
        if (response.has("data")) {
            JSONArray arr = response.getJSONArray("data");
            int[][] notDeleted = new int[arr.length()][2];
            for (int i = 0; i < arr.length(); ++i) {
                notDeleted[i][0] = arr.getJSONObject(i).getInt("id");
                notDeleted[i][1] = arr.getJSONObject(i).getInt("folder");
            }
            return notDeleted;
        }
        return new int[0][0];
    }

    public JSONObject deleteGetResponse(WebConversation webConv, String protocol, String hostname, String sessionId, long timestamp, int[][] ids) throws JSONException, IOException, SAXException {
        StringBuffer url = this.getUrl(sessionId, "delete", hostname, protocol);
        url.append("&timestamp=");
        url.append(timestamp);
        StringBuffer data = new StringBuffer("[");
        if (ids.length > 0) {
            for (int[] tuple : ids) {
                data.append("{folder : ");
                data.append(tuple[0]);
                data.append(", id : ");
                data.append(tuple[1]);
                data.append("},");
            }
            data.deleteCharAt(data.length() - 1);
        }
        data.append(']');
        JSONObject response = this.put(webConv, url.toString(), data.toString());
        return response;
    }

    public int[][] deleteFromFolders(WebConversation webConv, String hostname, String sessionId, long timestamp, int[][] ids) throws JSONException, IOException, SAXException {
        return this.deleteFromFolders(webConv, null, hostname, sessionId, timestamp, ids);
    }

    public int[] deleteSingle(WebConversation webConv, String hostname, String sessionId, long timestamp, int folder, int id) throws JSONException, IOException, SAXException {
        return this.delete(webConv, hostname, sessionId, timestamp, new int[][]{{folder, id}});
    }

    public int[] detach(WebConversation webConv, String hostname, String sessionId, long timestamp, int objectId, int[] versions) throws MalformedURLException, JSONException, IOException, SAXException {
        JSONArray arr;
        block6: {
            StringBuffer url = this.getUrl(sessionId, "detach", hostname);
            url.append("&timestamp=");
            url.append(timestamp);
            url.append("&id=");
            url.append(objectId);
            StringBuffer data = new StringBuffer("[");
            if (versions.length > 0) {
                for (int id : versions) {
                    data.append(id);
                    data.append(',');
                }
                data.deleteCharAt(data.length() - 1);
            }
            data.append(']');
            String content = this.putS(webConv, url.toString(), data.toString());
            arr = null;
            try {
                JSONObject response = new JSONObject(content);
                arr = response.getJSONArray("data");
                if (!response.has("error")) {
                    InfostoreAJAXTest.assertNotNull((Object)response.opt("timestamp"));
                }
            }
            catch (JSONException x) {
                Response res = Response.parse((String)content);
                if (!res.hasError()) break block6;
                throw new IOException(res.getErrorMessage());
            }
        }
        int[] notDeleted = new int[arr.length()];
        for (int i = 0; i < arr.length(); ++i) {
            notDeleted[i] = arr.getInt(i);
        }
        return notDeleted;
    }

    public Response revert(WebConversation webConv, String hostname, String sessionId, long timestamp, int objectId) throws MalformedURLException, JSONException, IOException, SAXException {
        StringBuffer url = this.getUrl(sessionId, "revert", hostname);
        url.append("&timestamp=");
        url.append(timestamp);
        url.append("&id=");
        url.append(objectId);
        return this.gT(webConv, url.toString());
    }

    public InputStream document(WebConversation webConv, String hostname, String sessionId, int id) throws HttpException, IOException {
        return this.document(webConv, hostname, sessionId, id, -1, null);
    }

    public InputStream document(WebConversation webConv, String hostname, String sessionId, int id, String contentType) throws HttpException, IOException {
        return this.document(webConv, hostname, sessionId, id, -1, contentType);
    }

    public InputStream document(WebConversation webConv, String hostname, String sessionId, int id, int version) throws HttpException, IOException {
        return this.document(webConv, hostname, sessionId, id, version, null);
    }

    public InputStream document(WebConversation webConv, String hostname, String sessionId, int id, int version, String contentType) throws HttpException, IOException {
        GetMethodWebRequest m = this.documentRequest(sessionId, hostname, id, version, contentType);
        WebResponse resp = webConv.getResource((WebRequest)m);
        return resp.getInputStream();
    }

    public GetMethodWebRequest documentRequest(String sessionId, String hostname, int id, int version, String contentType) {
        StringBuffer url = this.getUrl(sessionId, "document", hostname);
        url.append("&id=" + id);
        if (version != -1) {
            url.append("&version=" + version);
        }
        if (null != contentType) {
            contentType = contentType.replaceAll("/", "%2F");
            url.append("&content_type=");
            url.append(contentType);
        }
        return new GetMethodWebRequest(url.toString());
    }

    public int copy(WebConversation webConv, String hostname, String sessionId, int id, long timestamp, Map<String, String> modified, File upload, String contentType) throws JSONException, IOException {
        StringBuffer url = this.getUrl(sessionId, "copy", hostname);
        url.append("&id=");
        url.append(id);
        url.append("&timestamp=");
        url.append(timestamp);
        PostMethodWebRequest req = new PostMethodWebRequest(url.toString(), true);
        JSONObject obj = new JSONObject();
        for (String attr : modified.keySet()) {
            obj.put(attr, (Object)modified.get(attr));
        }
        req.setParameter("json", obj.toString());
        if (upload != null) {
            req.selectFile("file", upload, contentType);
        }
        WebResponse resp = webConv.getResource((WebRequest)req);
        JSONObject res = InfostoreAJAXTest.extractFromCallback(resp.getText());
        return Integer.valueOf(Response.parse((String)res.toString()).getData().toString());
    }

    public int copy(WebConversation webConv, String hostname, String sessionId, int id, long timestamp, Map<String, String> modified) throws MalformedURLException, JSONException, IOException, SAXException {
        StringBuffer url = this.getUrl(sessionId, "copy", hostname);
        url.append("&id=");
        url.append(id);
        url.append("&timestamp=");
        url.append(timestamp);
        JSONObject obj = new JSONObject();
        for (String attr : modified.keySet()) {
            obj.put(attr, (Object)modified.get(attr));
        }
        Response res = this.putT(webConv, url.toString(), obj.toString());
        if (res.hasError()) {
            throw new JSONException(res.getErrorMessage());
        }
        return Integer.parseInt(res.getData().toString());
    }

    public Response lock(WebConversation webConv, String hostname, String sessionId, int id, long timeDiff) throws MalformedURLException, JSONException, IOException, SAXException {
        StringBuffer url = this.getUrl(sessionId, "lock", hostname);
        url.append("&id=");
        url.append(id);
        if (timeDiff > 0L) {
            url.append("&diff=");
            url.append(timeDiff);
        }
        return this.gT(webConv, url.toString());
    }

    public Response lock(WebConversation webConv, String hostname, String sessionId, int id) throws MalformedURLException, JSONException, IOException, SAXException {
        return this.lock(webConv, hostname, sessionId, id, -1L);
    }

    public Response unlock(WebConversation webConv, String hostname, String sessionId, int id) throws MalformedURLException, JSONException, IOException, SAXException {
        StringBuffer url = this.getUrl(sessionId, "unlock", hostname);
        url.append("&id=");
        url.append(id);
        return this.gT(webConv, url.toString());
    }

    public Response search(WebConversation webConv, String hostname, String sessionId, String query, int[] columns) throws MalformedURLException, JSONException, IOException, SAXException {
        return this.search(webConv, hostname, sessionId, query, columns, -1, -1, null, -1, -1);
    }

    public Response search(WebConversation webConv, String hostname, String sessionId, String query, int[] columns, int folderId) throws JSONException, IOException, SAXException {
        return this.search(webConv, hostname, sessionId, query, columns, folderId, -1, null, -1, -1);
    }

    public Response search(WebConversation webConv, String hostname, String sessionId, String query, int[] columns, int folderId, int sort, String order, int start, int end) throws MalformedURLException, JSONException, IOException, SAXException {
        StringBuffer url = this.getUrl(sessionId, "search", hostname);
        url.append("&columns=");
        for (int c : columns) {
            url.append(c);
            url.append(',');
        }
        url.setLength(url.length() - 1);
        if (folderId != -1) {
            url.append("&folder=");
            url.append(folderId);
        }
        if (sort != -1) {
            url.append("&sort=");
            url.append(sort);
            url.append("&order=");
            url.append(order);
            if (start != -1) {
                url.append("&start=");
                url.append(start);
            }
            if (end != -1) {
                url.append("&end=");
                url.append(end);
            }
        }
        JSONObject queryObject = new JSONObject();
        queryObject.put("pattern", (Object)query);
        return this.putT(webConv, url.toString(), queryObject.toString());
    }

    public Response search(WebConversation webConv, String hostname, String sessionId, String query, int[] columns, int folderId, int sort, String order, int limit) throws MalformedURLException, JSONException, IOException, SAXException {
        StringBuffer url = this.getUrl(sessionId, "search", hostname);
        url.append("&columns=");
        for (int c : columns) {
            url.append(c);
            url.append(',');
        }
        url.setLength(url.length() - 1);
        if (folderId != -1) {
            url.append("&folder=");
            url.append(folderId);
        }
        if (sort != -1) {
            url.append("&sort=");
            url.append(sort);
            url.append("&order=");
            url.append(order);
            url.append("&limit=");
            url.append(limit);
        }
        JSONObject queryObject = new JSONObject();
        queryObject.put("pattern", (Object)query);
        return this.putT(webConv, url.toString(), queryObject.toString());
    }

    protected StringBuffer getUrl(String sessionId, String action, String hostname) {
        return this.getUrl(sessionId, action, hostname, null);
    }

    protected StringBuffer getUrl(String sessionId, String action, String hostname, String protocol) {
        StringBuffer url = new StringBuffer(protocol != null ? protocol : "http");
        url.append("://");
        url.append(hostname == null ? this.getHostName() : hostname);
        url.append("/ajax/infostore?session=");
        url.append(sessionId);
        url.append("&action=");
        url.append(action);
        return url;
    }

    @Override
    public String getHostName() {
        if (null == this.hostName) {
            return super.getHostName();
        }
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }
}

