/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.AbstractAJAXTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.tools.JSONCoercion;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.test.TestInit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class AttachmentTest
extends AbstractAJAXTest {
    protected String sessionId = null;
    protected File testFile = null;
    protected File testFile2 = null;
    protected List<AttachmentMetadata> clean = new ArrayList<AttachmentMetadata>();

    public AttachmentTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.sessionId = this.getSessionId();
        this.testFile = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        this.testFile2 = new File(TestInit.getTestProperty("webdavPropertiesFile"));
    }

    @Override
    public void tearDown() throws Exception {
        this.removeAttachments();
        super.tearDown();
    }

    public void removeAttachments() throws Exception {
        for (AttachmentMetadata attachment : this.clean) {
            this.detach(this.getWebConversation(), this.sessionId, attachment.getFolderId(), attachment.getAttachedId(), attachment.getModuleId(), new int[]{attachment.getId()});
        }
        this.clean.clear();
    }

    public Response attach(WebConversation webConv, String sessionId, int folderId, int attachedId, int moduleId, List<File> uploads) throws JSONException, IOException {
        return this.attach(webConv, sessionId, folderId, attachedId, moduleId, uploads, new HashMap<File, String>(), new HashMap<File, String>());
    }

    public Response attach(WebConversation webConv, String sessionId, int folderId, int attachedId, int moduleId, List<File> uploads, Map<File, String> filenames, Map<File, String> mimetypes) throws JSONException, IOException {
        StringBuffer url = this.getUrl(sessionId, "attach");
        PostMethodWebRequest req = new PostMethodWebRequest(url.toString(), true);
        int index = 0;
        for (File upload : uploads) {
            JSONObject object = new JSONObject();
            String filename = filenames.get(upload);
            String mimeType = mimetypes.get(upload);
            object.put("folder", folderId);
            object.put("attached", attachedId);
            object.put("module", moduleId);
            if (filename != null) {
                object.put("filename", (Object)filename);
            }
            if (mimeType != null) {
                object.put("file_mimetype", (Object)mimeType);
            }
            req.setParameter("json_" + index, object.toString());
            if (upload != null) {
                req.selectFile("file_" + index, upload);
            }
            ++index;
        }
        WebResponse resp = webConv.getResource((WebRequest)req);
        String html = resp.getText();
        JSONObject response = AttachmentTest.extractFromCallback(html);
        return Response.parse((String)response.toString());
    }

    public Response attach(WebConversation webConv, String sessionId, int folderId, int attachedId, int moduleId, File upload) throws JSONException, IOException {
        return this.attach(webConv, sessionId, folderId, attachedId, moduleId, upload, null, null);
    }

    public Response attach(WebConversation webConv, String sessionId, int folderId, int attachedId, int moduleId, File upload, String filename, String mimeType) throws JSONException, IOException {
        HashMap<File, String> filenames = new HashMap<File, String>();
        if (null != filename) {
            filenames.put(upload, filename);
        }
        HashMap<File, String> mimeTypes = new HashMap<File, String>();
        if (null != mimeType) {
            filenames.put(upload, mimeType);
        }
        return this.attach(webConv, sessionId, folderId, attachedId, moduleId, Arrays.asList(upload), filenames, mimeTypes);
    }

    public Response attach(WebConversation webConv, String sessionId, int folderId, int attachedId, int moduleId, Map<String, Object> dataSourceParams) throws JSONException, MalformedURLException, IOException, SAXException {
        StringBuffer url = this.getUrl(sessionId, "attach");
        JSONObject object = new JSONObject();
        object.put("folder", folderId);
        object.put("attached", attachedId);
        object.put("module", moduleId);
        object.put("datasource", JSONCoercion.coerceToJSON(dataSourceParams));
        JSONObject resp = this.put(webConv, url.toString(), object.toString());
        return Response.parse((String)resp.toString());
    }

    public Response detach(WebConversation webConv, String sessionId, int folderId, int attachedId, int moduleId, int[] ids) throws MalformedURLException, JSONException, IOException, SAXException {
        StringBuffer url = this.getUrl(sessionId, "detach");
        this.addCommon(url, folderId, attachedId, moduleId);
        StringBuffer data = new StringBuffer("[");
        for (int id : ids) {
            data.append(id);
            data.append(',');
        }
        data.setLength(data.length() - 1);
        data.append(']');
        return this.putT(webConv, url.toString(), data.toString());
    }

    public Response updates(WebConversation webConv, String sessionId, int folderId, int attachedId, int moduleId, long timestamp, int[] columns, int sort, String order) throws MalformedURLException, JSONException, IOException, SAXException {
        StringBuffer url = this.getUrl(sessionId, "updates");
        this.addCommon(url, folderId, attachedId, moduleId);
        this.addSort(url, columns, sort, order);
        url.append("&timestamp=" + timestamp);
        return this.gT(webConv, url.toString());
    }

    public Response all(WebConversation webConv, String sessionId, int folderId, int attachedId, int moduleId, int[] columns, int sort, String order) throws MalformedURLException, JSONException, IOException, SAXException {
        StringBuffer url = this.getUrl(sessionId, "all");
        this.addCommon(url, folderId, attachedId, moduleId);
        this.addSort(url, columns, sort, order);
        return this.gT(webConv, url.toString());
    }

    private void addSort(StringBuffer url, int[] columns, int sort, String order) {
        StringBuffer cols = new StringBuffer();
        for (int id : columns) {
            cols.append(id);
            cols.append(',');
        }
        cols.setLength(cols.length() - 1);
        url.append("&columns=");
        url.append(cols.toString());
        url.append("&sort=");
        url.append(sort);
        url.append("&order=");
        url.append(order);
    }

    public Response list(WebConversation webConv, String sessionId, int folderId, int attachedId, int moduleId, int[] ids, int[] columns) throws JSONException, MalformedURLException, IOException, SAXException {
        StringBuffer url = this.getUrl(sessionId, "list");
        this.addCommon(url, folderId, attachedId, moduleId);
        StringBuffer data = new StringBuffer("[");
        for (int id : ids) {
            data.append(id);
            data.append(',');
        }
        data.setLength(data.length() - 1);
        data.append(']');
        StringBuffer cols = new StringBuffer();
        for (int col : columns) {
            cols.append(col);
            cols.append(',');
        }
        cols.setLength(cols.length() - 1);
        url.append("&columns=");
        url.append(cols);
        return this.putT(webConv, url.toString(), data.toString());
    }

    public Response get(WebConversation webConv, String sessionId, int folderId, int attachedId, int moduleId, int id) throws MalformedURLException, JSONException, IOException, SAXException {
        StringBuffer url = this.getUrl(sessionId, "get");
        this.addCommon(url, folderId, attachedId, moduleId);
        url.append("&id=" + id);
        return this.gT(webConv, url.toString());
    }

    public InputStream document(WebConversation webConv, String sessionId, int folderId, int attachedId, int moduleId, int id) throws IOException {
        return this.document(webConv, sessionId, folderId, attachedId, moduleId, id, null);
    }

    public InputStream document(WebConversation webConv, String sessionId, int folderId, int attachedId, int moduleId, int id, String contentType) throws IOException {
        GetMethodWebRequest m = this.documentRequest(sessionId, folderId, attachedId, moduleId, id, contentType);
        WebResponse resp = this.getWebConversation().getResource((WebRequest)m);
        return resp.getInputStream();
    }

    public GetMethodWebRequest documentRequest(String sessionId, int folderId, int attachedId, int moduleId, int id, String contentType) {
        StringBuffer url = this.getUrl(sessionId, "document");
        this.addCommon(url, folderId, attachedId, moduleId);
        url.append("&id=" + id);
        if (null != contentType) {
            contentType = contentType.replaceAll("/", "%2F");
            url.append("&content_type=");
            url.append(contentType);
        }
        return new GetMethodWebRequest(url.toString());
    }

    public Response quota(WebConversation webConv, String sessionId) throws MalformedURLException, JSONException, IOException, SAXException {
        StringBuffer url = new StringBuffer("http://");
        url.append(this.getHostName());
        url.append("/ajax/quota?session=");
        url.append(sessionId);
        url.append("&action=filestore");
        return this.gT(webConv, url.toString());
    }

    private void addCommon(StringBuffer url, int folderId, int attachedId, int moduleId) {
        url.append("&folder=" + folderId);
        url.append("&attached=" + attachedId);
        url.append("&module=" + moduleId);
    }

    protected StringBuffer getUrl(String sessionId, String action) {
        StringBuffer url = new StringBuffer("http://");
        url.append(this.getHostName());
        url.append("/ajax/attachment?session=");
        url.append(sessionId);
        url.append("&action=");
        url.append(action);
        return url;
    }
}

