/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.internal;

import com.openexchange.context.ContextService;
import com.openexchange.event.CommonEvent;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.subscribe.Subscription;
import com.openexchange.subscribe.SubscriptionStorage;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class FolderCleanUpEventHandler
implements EventHandler {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(FolderCleanUpEventHandler.class));
    private final ContextService contexts;
    private final SubscriptionStorage storage;
    private ServiceRegistration<EventHandler> registration;

    public FolderCleanUpEventHandler(BundleContext context, SubscriptionStorage storage, ContextService contexts) {
        this.contexts = contexts;
        this.storage = storage;
        this.register(context);
    }

    private void register(BundleContext context) {
        Hashtable<String, String[]> serviceProperties = new Hashtable<String, String[]>(1);
        ((Dictionary)serviceProperties).put("event.topics", new String[]{"com/openexchange/groupware/folder/delete"});
        this.registration = context.registerService(EventHandler.class, (Object)this, serviceProperties);
    }

    public void close() {
        this.registration.unregister();
    }

    public void handleEvent(Event event) {
        Context context;
        CommonEvent commonEvent = (CommonEvent)event.getProperty("OX_EVENT");
        FolderObject actionObj = (FolderObject)commonEvent.getActionObj();
        String folderId = String.valueOf(actionObj.getObjectID());
        try {
            context = this.contexts.getContext(commonEvent.getContextId());
        }
        catch (OXException e) {
            LOG.error((Object)("Could not delete all dependent subscriptions: " + e.getMessage()), (Throwable)e);
            return;
        }
        try {
            List<Subscription> subscriptions = this.storage.getSubscriptions(context, folderId);
            for (Subscription subscription : subscriptions) {
                this.storage.forgetSubscription(subscription);
            }
        }
        catch (OXException e) {
            LOG.error((Object)("Could not delete all dependent subscriptions: " + e.getMessage()), (Throwable)e);
        }
    }
}

