/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum SubscriptionErrorMessage implements OXExceptionCode
{
    SQLException(CATEGORY_ERROR, 1, "Please try again later.", "A SQL error occurred."),
    ParseException(CATEGORY_ERROR, 2, "Provide well-formed HTML.", "A parsing error occurred: %1$s."),
    IDGiven(CATEGORY_ERROR, 3, "Do not set a ID when saving a publication", "Unable to save a given ID."),
    SubscriptionNotFound(CATEGORY_USER_INPUT, 5, "Provide a valid id.", "Could not find this subscription"),
    ParsingError(CATEGORY_ERROR, 6, "Check value to parse.", "Parsing error."),
    INVALID_LOGIN(CATEGORY_USER_INPUT, 7, "Please correct the login or password and try again", "The login or password you entered are wrong"),
    COMMUNICATION_PROBLEM(CATEGORY_SERVICE_DOWN, 8, "Make sure the service is still available and there are no major changes on the website.", "Service unavailable"),
    TEMPORARILY_UNAVAILABLE(CATEGORY_SERVICE_DOWN, 8, "Please try using this service again at a later time", "This service is temporarily unavailable. This may be due to a temporary outage or a permanent change on the 3rd-party-side. Please try using this service again at a later time"),
    INVALID_WORKFLOW(CATEGORY_CONFIGURATION, 9, "Please correct the steps of this workflow so that output of one step and input of the next step match", "The steps of this crawling workflow do not fit together"),
    INACTIVE_SOURCE(CATEGORY_CONFIGURATION, 10, "Ask an administrator to check the available subscription sources", "The subscription source this subscription belongs to is currently inactive, and cannot provide data."),
    MISSING_ARGUMENT(CATEGORY_USER_INPUT, 11, "Missing argument. %1$s", "Missing argument. %1$s"),
    PERMISSION_DENIED(CATEGORY_WARNING, 12, "You do not have the permission to complete this operation.", "You do not have the permission to complete this operation."),
    UNEXPECTED_ERROR(CATEGORY_ERROR, 9999, "An unexpected error occurred: %1$s.", "An unexpected error occurred: %1$s.");

    private Category category;
    private int errorCode;
    private String help;
    private String message;

    private SubscriptionErrorMessage(Category category, int errorCode, String help, String message) {
        this.category = category;
        this.errorCode = errorCode;
        this.help = help;
        this.message = message;
    }

    public String getPrefix() {
        return "SUB";
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.errorCode;
    }

    public String getHelp() {
        return this.help;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

