/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit;

import com.openexchange.tools.versit.VersitDefinition;
import java.io.IOException;
import java.io.Writer;

public class FoldingWriter
implements VersitDefinition.Writer {
    private final Writer w;
    private int LineLength;
    private final int MAX = 75;
    private final String INDENTATION = " ";

    public FoldingWriter(Writer w) {
        this.w = w;
    }

    public void sdfwrite(String s) throws IOException {
        int start = 0;
        for (int len = s.length() + this.LineLength; len > 75; len -= 75) {
            int delta = 75 - this.LineLength;
            this.w.write(s.substring(start, start + delta));
            this.w.write("\n ");
            start += delta;
            this.LineLength = 1;
        }
        this.w.write(s.substring(start));
        this.LineLength += s.length() - start;
    }

    public void write(String s) throws IOException {
        if (s.length() > 75) {
            this.writeLong(s);
        } else {
            this.w.write(s);
        }
    }

    private void writeLong(String s) throws IOException {
        int length = 75 - " ".length() - 2;
        for (int offset = 0; offset < s.length(); offset += length) {
            this.w.write("\n");
            this.w.write(" ");
            this.w.write(s, offset, offset + length < s.length() ? length : s.length() - offset);
        }
    }

    public void writeln() throws IOException {
        this.w.write("\n");
        this.LineLength = 0;
    }

    public void writeln(String s) throws IOException {
        this.write(s);
        this.writeln();
    }

    @Override
    public void flush() throws IOException {
        this.w.flush();
    }

    @Override
    public void close() throws IOException {
        this.w.close();
    }
}

