/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.internal;

import com.openexchange.exception.OXException;
import com.openexchange.tools.file.external.FileStorage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public class CompositingFileStorage
implements FileStorage {
    private final Map<String, FileStorage> prefixedStores = new HashMap<String, FileStorage>();
    private FileStorage standardFS;
    private String savePrefix;

    @Override
    public boolean deleteFile(String identifier) throws OXException {
        PreparedName prepared = this.prepareName(identifier);
        return prepared.fs.deleteFile(prepared.name);
    }

    @Override
    public Set<String> deleteFiles(String[] identifiers) throws OXException {
        HashMap<FileStorage, LinkedList<String>> partitions = new HashMap<FileStorage, LinkedList<String>>();
        HashMap<FileStorage, String> prefixes = new HashMap<FileStorage, String>();
        for (String name : identifiers) {
            PreparedName preparedName = this.prepareName(name);
            LinkedList<String> list = (LinkedList<String>)partitions.get(preparedName.fs);
            if (list == null) {
                list = new LinkedList<String>();
                partitions.put(preparedName.fs, list);
            }
            list.add(preparedName.name);
            if (preparedName.prefix == null) continue;
            prefixes.put(preparedName.fs, preparedName.prefix);
        }
        HashSet<String> notDeleted = new HashSet<String>();
        for (Map.Entry entry : partitions.entrySet()) {
            FileStorage fileStorage = (FileStorage)entry.getKey();
            List ids = (List)entry.getValue();
            Set<String> files = fileStorage.deleteFiles(ids.toArray(new String[ids.size()]));
            String prefix = (String)prefixes.get(fileStorage);
            if (prefix == null) {
                notDeleted.addAll(files);
                continue;
            }
            for (String file : files) {
                notDeleted.add(prefix + "/" + file);
            }
        }
        return notDeleted;
    }

    @Override
    public InputStream getFile(String name) throws OXException {
        PreparedName prepared = this.prepareName(name);
        return prepared.fs.getFile(prepared.name);
    }

    @Override
    public SortedSet<String> getFileList() throws OXException {
        SortedSet<String> fileList = this.standardFS.getFileList();
        for (Map.Entry<String, FileStorage> entry : this.prefixedStores.entrySet()) {
            String prefix = entry.getKey();
            FileStorage fileStorage = entry.getValue();
            SortedSet<String> files = fileStorage.getFileList();
            for (String file : files) {
                fileList.add(prefix + "/" + file);
            }
        }
        return fileList;
    }

    @Override
    public long getFileSize(String name) throws OXException {
        PreparedName preparedName = this.prepareName(name);
        return preparedName.fs.getFileSize(preparedName.name);
    }

    @Override
    public String getMimeType(String name) throws OXException {
        return this.standardFS.getMimeType(name);
    }

    @Override
    public void recreateStateFile() throws OXException {
        this.standardFS.recreateStateFile();
        for (FileStorage fs : this.prefixedStores.values()) {
            fs.recreateStateFile();
        }
    }

    @Override
    public void remove() throws OXException {
        this.standardFS.remove();
        for (FileStorage fs : this.prefixedStores.values()) {
            fs.remove();
        }
    }

    @Override
    public String saveNewFile(InputStream file) throws OXException {
        if (this.savePrefix != null) {
            return this.saveNewFileInPrefixedSto(this.savePrefix, file);
        }
        return this.standardFS.saveNewFile(file);
    }

    protected String saveNewFileInPrefixedSto(String prefix, InputStream file) throws OXException {
        FileStorage fileStorage = this.prefixedStores.get(prefix);
        return prefix + "/" + fileStorage.saveNewFile(file);
    }

    @Override
    public boolean stateFileIsCorrect() throws OXException {
        boolean stateFileIsCorrect = this.standardFS.stateFileIsCorrect();
        if (!stateFileIsCorrect) {
            return false;
        }
        for (FileStorage fs : this.prefixedStores.values()) {
            boolean isCorrect = fs.stateFileIsCorrect();
            if (isCorrect) continue;
            return false;
        }
        return true;
    }

    public void addStore(FileStorage fs) {
        this.standardFS = fs;
    }

    public void addStore(String prefix, FileStorage fs) {
        this.prefixedStores.put(prefix, fs);
    }

    protected PreparedName prepareName(String canonicalName) {
        int idx = canonicalName.indexOf(47);
        if (idx < 0) {
            return new PreparedName(this.standardFS, canonicalName, null);
        }
        String prefix = canonicalName.substring(0, idx);
        String rest = canonicalName.substring(idx + 1);
        FileStorage fileStorage = this.prefixedStores.get(prefix);
        if (fileStorage != null) {
            return new PreparedName(fileStorage, rest, prefix);
        }
        return new PreparedName(this.standardFS, canonicalName, null);
    }

    public void setSavePrefix(String savePrefix) {
        this.savePrefix = savePrefix;
    }

    protected static final class PreparedName {
        public FileStorage fs;
        public String name;
        public String prefix;

        public PreparedName(FileStorage fs, String name, String prefix) {
            this.fs = fs;
            this.name = name;
            this.prefix = prefix;
        }
    }
}

