/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.internal;

import com.openexchange.exception.OXException;
import com.openexchange.mail.utils.MailPasswordUtil;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.secret.Decrypter;
import com.openexchange.session.Session;
import java.security.GeneralSecurityException;

public final class GenericProperty
implements Decrypter {
    public final int accountId;
    public final Session session;
    public final String login;
    public final String server;

    public GenericProperty(int accountId, Session session, String login, String server) {
        this.accountId = accountId;
        this.session = session;
        this.login = login;
        this.server = server;
    }

    public String getDecrypted(Session session, String encrypted) throws OXException {
        if (null == encrypted || encrypted.length() == 0) {
            return "";
        }
        try {
            return MailPasswordUtil.decrypt(encrypted, session.getPassword());
        }
        catch (GeneralSecurityException e) {
            throw MailAccountExceptionCodes.PASSWORD_DECRYPTION_FAILED.create(e, this.login, this.server, session.getUserId(), session.getContextId());
        }
    }
}

