/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.converters;

import com.openexchange.mail.mime.HeaderCollection;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.Field;

class HeaderContentHandler
implements ContentHandler {
    static final EndHeaderException END_HEADER_EXCEPTION = new EndHeaderException();
    private HeaderCollection headers;
    private boolean active;

    public HeaderContentHandler() {
    }

    protected HeaderContentHandler(HeaderCollection headers) {
        this.headers = headers;
    }

    public void startMessage() throws MimeException {
    }

    public void endMessage() throws MimeException {
    }

    public void startBodyPart() throws MimeException {
    }

    public void endBodyPart() throws MimeException {
    }

    public void startHeader() throws MimeException {
        if (null == this.headers) {
            this.headers = new HeaderCollection(128);
        }
        this.active = true;
    }

    public void field(Field rawField) throws MimeException {
        if (this.active) {
            String name = rawField.getName();
            if ("x-original-headers".equals(name)) {
                return;
            }
            String value = rawField.getBody();
            if (HeaderContentHandler.isEmpty(value)) {
                this.headers.addHeader(name, "");
            } else {
                this.headers.addHeader(name, MimeMessageUtility.unfold(value));
            }
        }
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    public void endHeader() throws MimeException {
        this.active = false;
        throw END_HEADER_EXCEPTION;
    }

    public void preamble(InputStream is) throws MimeException, IOException {
    }

    public void epilogue(InputStream is) throws MimeException, IOException {
    }

    public void startMultipart(BodyDescriptor bd) throws MimeException {
    }

    public void endMultipart() throws MimeException {
    }

    public void body(BodyDescriptor bd, InputStream is) throws MimeException, IOException {
    }

    public void raw(InputStream is) throws MimeException, IOException {
    }

    static final class EndHeaderException
    extends MimeException {
        private static final long serialVersionUID = 7701096104485623980L;

        EndHeaderException() {
            super("endHeader");
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

