/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration.osgi;

import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.server.osgi.ServerActivator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class TrackerAvailabilityChecker<S>
extends ServiceTracker<S, S>
implements UserConfiguration.AvailabilityChecker {
    private final AtomicBoolean available;

    public static <S> UserConfiguration.AvailabilityChecker getAvailabilityCheckerFor(Class<S> clazz, boolean defaultAvailability) {
        BundleContext bundleContext = ServerActivator.getContext();
        if (null == bundleContext) {
            return UserConfiguration.TRUE_AVAILABILITY_CHECKER;
        }
        return new TrackerAvailabilityChecker<S>(clazz, defaultAvailability);
    }

    private TrackerAvailabilityChecker(Class<S> clazz, boolean defaultAvailability) {
        super(ServerActivator.getContext(), clazz, null);
        this.available = new AtomicBoolean(defaultAvailability);
    }

    public void start() {
        if (this.available.compareAndSet(true, false)) {
            this.open();
        }
    }

    public void stop() {
        this.close();
    }

    public S addingService(ServiceReference<S> reference) {
        if (this.available.compareAndSet(false, true)) {
            return (S)super.addingService(reference);
        }
        return null;
    }

    public void removedService(ServiceReference<S> reference, S service) {
        if (null != service) {
            this.available.compareAndSet(true, false);
            this.context.ungetService(reference);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.available.get();
    }
}

