/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class POP3CreateTableTask
implements UpdateTask {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(POP3CreateTableTask.class));
    private static final String[] types = new String[]{"TABLE"};

    @Override
    public int addedWithVersion() {
        return 42;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGHEST.priority;
    }

    private static final String getCreatePOP3IDsMapping() {
        return "CREATE TABLE pop3_storage_ids (cid INT4 unsigned NOT NULL,user INT4 unsigned NOT NULL,id INT4 unsigned NOT NULL,uidl VARCHAR(70) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,fullname VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,uid VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,PRIMARY KEY (cid, user, id, uidl)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    }

    private static final String getCreatePOP3DeletedContainer() {
        return "CREATE TABLE pop3_storage_deleted (cid INT4 unsigned NOT NULL,user INT4 unsigned NOT NULL,id INT4 unsigned NOT NULL,uidl VARCHAR(70) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,PRIMARY KEY (cid, user, id, uidl)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        this.createTable("pop3_storage_ids", POP3CreateTableTask.getCreatePOP3IDsMapping(), contextId);
        this.createTable("pop3_storage_deleted", POP3CreateTableTask.getCreatePOP3DeletedContainer(), contextId);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"UpdateTask 'POP3CreateTableTask' successfully performed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable(String tablename, String sqlCreate, int contextId) throws OXException {
        PreparedStatement stmt;
        Connection writeCon;
        block5: {
            writeCon = Database.get(contextId, true);
            stmt = null;
            if (!POP3CreateTableTask.tableExists(tablename, writeCon.getMetaData())) break block5;
            DBUtils.closeSQLStuff(null, stmt);
            Database.back(contextId, true, writeCon);
            return;
        }
        try {
            try {
                stmt = writeCon.prepareStatement(sqlCreate);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw POP3CreateTableTask.createSQLError(e);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(null, stmt);
            Database.back(contextId, true, writeCon);
            throw throwable;
        }
        DBUtils.closeSQLStuff(null, stmt);
        Database.back(contextId, true, writeCon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tableExists(String tableName, DatabaseMetaData dbmd) throws SQLException {
        boolean bl;
        ResultSet resultSet = null;
        try {
            resultSet = dbmd.getTables(null, null, tableName, types);
            bl = resultSet.next();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(resultSet, null);
            throw throwable;
        }
        DBUtils.closeSQLStuff(resultSet, null);
        return bl;
    }

    private static OXException createSQLError(SQLException e) {
        return UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
    }
}

