/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.filestore;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.provider.SimpleDBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.delete.ContextDelete;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.QuotaFileStorage;
import java.sql.Connection;

public final class FileStorageRemover
extends ContextDelete {
    @Override
    public void deletePerformed(DeleteEvent event, Connection readCon, Connection writeCon) throws OXException {
        if (this.isContextDelete(event)) {
            this.removeFileStorage(event.getContext(), new SimpleDBProvider(readCon, writeCon));
        }
    }

    private void removeFileStorage(Context ctx, DBProvider dbProvider) throws OXException {
        FileStorage stor = this.getFileStorage(ctx, dbProvider);
        stor.remove();
    }

    private FileStorage getFileStorage(Context ctx, DBProvider dbProvider) throws OXException {
        return QuotaFileStorage.getInstance(FilestoreStorage.createURI(ctx), ctx);
    }
}

