/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact.helpers;

import com.davekoelle.AlphanumComparator;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.search.Order;
import java.util.Comparator;
import java.util.Locale;

public class SpecialAlphanumSortContactComparator
implements Comparator<Contact> {
    private final Comparator<String> stringComparator;
    private final int inverse;

    public SpecialAlphanumSortContactComparator() {
        this.stringComparator = new AlphanumComparator();
        this.inverse = 1;
    }

    public SpecialAlphanumSortContactComparator(Locale locale) {
        this.stringComparator = new AlphanumComparator(locale);
        this.inverse = 1;
    }

    public SpecialAlphanumSortContactComparator(Comparator<String> stringComparator, Order sortOrder) {
        this.stringComparator = stringComparator;
        this.inverse = sortOrder == Order.DESCENDING ? -1 : 1;
    }

    @Override
    public int compare(Contact contact1, Contact contact2) {
        int compared = this.stringComparator.compare(contact1.getSortName(), contact2.getSortName());
        return this.inverse * compared;
    }

    private static boolean isLastName(int field) {
        return 611 == field || 502 == field;
    }

    private int compareGivenName(Contact contact1, Contact contact2) {
        String givenName1;
        String string = contact1.containsYomiFirstName() ? contact1.getYomiFirstName() : (givenName1 = contact1.containsGivenName() ? contact1.getGivenName() : "");
        String givenName2 = contact2.containsYomiFirstName() ? contact2.getYomiFirstName() : (contact2.containsGivenName() ? contact2.getGivenName() : "");
        return this.stringComparator.compare(givenName1, givenName2);
    }

    private static int detectFirstNonEmptyField(Contact contact) {
        if (SpecialAlphanumSortContactComparator.isNotEmpty(contact.getYomiLastName())) {
            return 611;
        }
        if (SpecialAlphanumSortContactComparator.isNotEmpty(contact.getSurName())) {
            return 502;
        }
        if (SpecialAlphanumSortContactComparator.isNotEmpty(contact.getDisplayName())) {
            return 500;
        }
        if (SpecialAlphanumSortContactComparator.isNotEmpty(contact.getYomiCompany())) {
            return 612;
        }
        if (SpecialAlphanumSortContactComparator.isNotEmpty(contact.getCompany())) {
            return 569;
        }
        if (SpecialAlphanumSortContactComparator.isNotEmpty(contact.getEmail1())) {
            return 555;
        }
        if (SpecialAlphanumSortContactComparator.isNotEmpty(contact.getEmail2())) {
            return 556;
        }
        return 0;
    }

    private static boolean isNotEmpty(String string) {
        if (null != string) {
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isWhitespace(string.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }
}

