/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.impl;

import com.openexchange.database.tx.AbstractDBAction;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.impl.AttachmentListQueryAction;
import java.sql.SQLException;
import java.util.Date;

public class DeleteAttachmentAction
extends AttachmentListQueryAction {
    protected void undoAction() throws OXException {
        if (this.getAttachments().size() == 0) {
            return;
        }
        this.doUpdates(new AbstractDBAction.Update(this.getQueryCatalog().getDelete("del_attachment", this.getAttachments())){

            @Override
            public void fillStatement() throws SQLException {
                this.stmt.setInt(1, DeleteAttachmentAction.this.getContext().getContextId());
            }
        });
        this.doUpdates(this.getQueryCatalog().getInsert(), this.getAttachments(), false);
    }

    public void perform() throws OXException {
        if (this.getAttachments().size() == 0) {
            return;
        }
        final Date delDate = new Date();
        AbstractDBAction.UpdateBlock[] updates = new AbstractDBAction.UpdateBlock[this.getAttachments().size() + 1];
        int i = 0;
        for (final AttachmentMetadata m : this.getAttachments()) {
            updates[i++] = new AbstractDBAction.Update(this.getQueryCatalog().getInsertIntoDel()){

                @Override
                public void fillStatement() throws SQLException {
                    this.stmt.setInt(1, m.getId());
                    this.stmt.setLong(2, delDate.getTime());
                    this.stmt.setInt(3, DeleteAttachmentAction.this.getContext().getContextId());
                    this.stmt.setInt(4, m.getAttachedId());
                    this.stmt.setInt(5, m.getModuleId());
                }
            };
        }
        updates[i++] = new AbstractDBAction.Update(this.getQueryCatalog().getDelete("prg_attachment", this.getAttachments())){

            @Override
            public void fillStatement() throws SQLException {
                this.stmt.setInt(1, DeleteAttachmentAction.this.getContext().getContextId());
            }
        };
        this.doUpdates(updates);
    }
}

