/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.outlook.sql;

import com.davekoelle.AlphanumComparator;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.outlook.sql.Delete;
import com.openexchange.folderstorage.outlook.sql.Utility;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class Duplicate {
    private Duplicate() {
    }

    public static Map<String, List<String>> lookupDuplicateNames(int cid, int tree, int user) throws OXException {
        DatabaseService databaseService = Utility.getDatabaseService();
        Connection con = databaseService.getReadOnly(cid);
        ConnectionManager cm = new ConnectionManager(con, false, cid, databaseService);
        try {
            Map<String, List<String>> map = Duplicate.lookupDuplicateNames(cid, tree, user, cm);
            return map;
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            cm.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, List<String>> lookupDuplicateNames(int cid, int tree, int user, ConnectionManager cm) throws OXException {
        Iterator i$;
        HashMap<String, List<String>> name2ids;
        int pos;
        if (null == cm) {
            return Duplicate.lookupDuplicateNames(cid, tree, user);
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            HashMap<String, String> name2parent;
            block25: {
                block24: {
                    stmt = cm.connection.prepareStatement("SELECT name, COUNT(name), parentId FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? GROUP BY parentId, name");
                    pos = 1;
                    stmt.setInt(pos++, cid);
                    stmt.setInt(pos++, tree);
                    stmt.setInt(pos, user);
                    rs = stmt.executeQuery();
                    if (rs.next()) break block24;
                    Map<String, List<String>> map = Collections.emptyMap();
                    DBUtils.closeSQLStuff(rs, stmt);
                    DBUtils.closeSQLStuff(rs, stmt);
                    return map;
                }
                name2parent = new HashMap<String, String>();
                do {
                    if (rs.getInt(2) <= 1) continue;
                    name2parent.put(rs.getString(1), rs.getString(3));
                } while (rs.next());
                if (!name2parent.isEmpty()) break block25;
                Map<String, List<String>> map = Collections.emptyMap();
                {
                    catch (Throwable throwable) {
                        DBUtils.closeSQLStuff(rs, stmt);
                        throw throwable;
                    }
                }
                DBUtils.closeSQLStuff(rs, stmt);
                DBUtils.closeSQLStuff(rs, stmt);
                return map;
            }
            DBUtils.closeSQLStuff(rs, stmt);
            name2ids = new HashMap<String, List<String>>();
            i$ = name2parent.entrySet().iterator();
        }
        catch (SQLException e) {
            try {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                catch (RuntimeException e2) {
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        while (i$.hasNext()) {
            Map.Entry entry = i$.next();
            try {
                stmt = cm.connection.prepareStatement("SELECT folderId FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND name = ? AND parentId = ?");
                String name = (String)entry.getKey();
                pos = 1;
                stmt.setInt(pos++, cid);
                stmt.setInt(pos++, tree);
                stmt.setInt(pos++, user);
                stmt.setString(pos++, name);
                stmt.setString(pos++, (String)entry.getValue());
                rs = stmt.executeQuery();
                if (!rs.next()) continue;
                ArrayList<String> folderIds = new ArrayList<String>(4);
                do {
                    folderIds.add(rs.getString(1));
                } while (rs.next());
                Collections.sort(folderIds, new AlphanumComparator(Locale.US));
                folderIds.remove(0);
                name2ids.put(name, folderIds);
            }
            finally {
                DBUtils.closeSQLStuff(rs, stmt);
            }
        }
        if (!name2ids.isEmpty()) {
            boolean transactional;
            boolean bl = transactional = !cm.connection.getAutoCommit() && cm.readWrite;
            if (transactional) {
                Duplicate.deleteEntries(name2ids, cid, tree, user, cm.connection);
            } else {
                cm.upgradeConnection();
                Connection connection = cm.connection;
                boolean rollback = false;
                try {
                    connection.setAutoCommit(false);
                    rollback = true;
                    Duplicate.deleteEntries(name2ids, cid, tree, user, connection);
                    connection.commit();
                    rollback = false;
                }
                finally {
                    if (rollback) {
                        DBUtils.rollback(connection);
                    }
                    DBUtils.autocommit(connection);
                }
            }
        }
        HashMap<String, List<String>> hashMap = name2ids;
        DBUtils.closeSQLStuff(rs, stmt);
        return hashMap;
    }

    private static void deleteEntries(Map<String, List<String>> name2ids, int cid, int tree, int user, Connection con) throws OXException {
        for (Map.Entry<String, List<String>> entry : name2ids.entrySet()) {
            List<String> folderIds = entry.getValue();
            int sz = folderIds.size();
            for (int i = 0; i < sz; ++i) {
                Delete.deleteFolder(cid, tree, user, folderIds.get(i), false, false, con);
            }
        }
    }

    private static final class ConnectionManager {
        private final DatabaseService databaseService;
        private final int contextId;
        protected boolean readWrite;
        protected Connection connection;

        protected ConnectionManager(Connection connection, boolean readWrite, int contextId, DatabaseService databaseService) {
            this.databaseService = databaseService;
            this.contextId = contextId;
            this.connection = connection;
            this.readWrite = readWrite;
        }

        protected void upgradeConnection() throws OXException {
            if (this.readWrite) {
                return;
            }
            this.releaseConnection();
            this.connection = this.databaseService.getWritable(this.contextId);
            this.readWrite = true;
        }

        protected void releaseConnection() {
            Connection connection = this.connection;
            if (null == connection) {
                return;
            }
            if (this.readWrite) {
                DBUtils.autocommit(connection);
                this.databaseService.backWritable(this.contextId, connection);
            } else {
                this.databaseService.backReadOnly(this.contextId, connection);
            }
            this.connection = null;
        }
    }
}

