/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.messaging.osgi;

import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.mail.contentType.MailContentType;
import com.openexchange.folderstorage.messaging.MessagingFolderStorage;
import com.openexchange.folderstorage.messaging.MessagingFolderStorageServiceRegistry;
import com.openexchange.log.LogFactory;
import com.openexchange.messaging.registry.MessagingServiceRegistry;
import com.openexchange.osgi.DeferredActivator;
import com.openexchange.osgi.ServiceRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class MessagingFolderStorageActivator
extends DeferredActivator {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MessagingFolderStorageActivator.class));
    private ServiceRegistration<FolderStorage> folderStorageRegistration;
    private List<ServiceTracker<?, ?>> trackers;

    protected Class<?>[] getNeededServices() {
        return new Class[]{MessagingServiceRegistry.class};
    }

    protected void handleAvailability(Class<?> clazz) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Re-available service: " + clazz.getName()));
        }
        MessagingFolderStorageServiceRegistry.getServiceRegistry().addService(clazz, this.getService(clazz));
    }

    protected void handleUnavailability(Class<?> clazz) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Absent service: " + clazz.getName()));
        }
        MessagingFolderStorageServiceRegistry.getServiceRegistry().removeService(clazz);
    }

    protected void startBundle() throws Exception {
        try {
            Class<?>[] classes;
            ServiceRegistry registry = MessagingFolderStorageServiceRegistry.getServiceRegistry();
            registry.clearRegistry();
            for (Class<?> classe : classes = this.getNeededServices()) {
                Object service = this.getService(classe);
                if (null == service) continue;
                registry.addService(classe, service);
            }
            this.trackers = new ArrayList(4);
            this.trackers.add(new ServiceTracker(this.context, FolderStorage.class, (ServiceTrackerCustomizer)new Switcher(this.context)));
            for (ServiceTracker<?, ?> tracker : this.trackers) {
                tracker.open();
            }
            Hashtable<String, String> dictionary = new Hashtable<String, String>();
            ((Dictionary)dictionary).put("tree", FolderStorage.REAL_TREE_ID);
            this.folderStorageRegistration = this.context.registerService(FolderStorage.class, (Object)new MessagingFolderStorage(), dictionary);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected void stopBundle() throws Exception {
        try {
            if (null != this.trackers) {
                while (!this.trackers.isEmpty()) {
                    this.trackers.remove(0).close();
                }
                this.trackers = null;
            }
            if (null != this.folderStorageRegistration) {
                this.folderStorageRegistration.unregister();
                this.folderStorageRegistration = null;
            }
            MessagingFolderStorageServiceRegistry.getServiceRegistry().clearRegistry();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private static final class Switcher
    implements ServiceTrackerCustomizer<FolderStorage, FolderStorage> {
        private final BundleContext context;

        Switcher(BundleContext context) {
            this.context = context;
        }

        public FolderStorage addingService(ServiceReference<FolderStorage> reference) {
            FolderStorage folderStorage = (FolderStorage)this.context.getService(reference);
            if (Arrays.asList(folderStorage.getSupportedContentTypes()).contains(MailContentType.getInstance())) {
                MessagingFolderStorage.setMailFolderStorageAvailable(true);
                return folderStorage;
            }
            this.context.ungetService(reference);
            return null;
        }

        public void modifiedService(ServiceReference<FolderStorage> reference, FolderStorage service) {
        }

        public void removedService(ServiceReference<FolderStorage> reference, FolderStorage service) {
            if (null != service) {
                FolderStorage folderStorage = service;
                if (Arrays.asList(folderStorage.getSupportedContentTypes()).contains(MailContentType.getInstance())) {
                    MessagingFolderStorage.setMailFolderStorageAvailable(false);
                }
                this.context.ungetService(reference);
            }
        }
    }
}

