/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database.getfolder;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.database.DatabaseFolder;
import com.openexchange.folderstorage.database.LocalizedDatabaseFolder;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import gnu.trove.list.array.TIntArrayList;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;

public final class SystemInfostoreFolder {
    private SystemInfostoreFolder() {
    }

    public static DatabaseFolder getSystemInfostoreFolder(FolderObject fo, boolean altNames) {
        LocalizedDatabaseFolder retval = new LocalizedDatabaseFolder(fo);
        retval.setName(altNames ? "Files" : "Infostore");
        retval.setContentType(InfostoreContentType.getInstance());
        retval.setSubfolderIDs(null);
        retval.setSubscribedSubfolders(true);
        return retval;
    }

    public static int[] getSystemInfostoreFolderSubfoldersAsInt(User user, UserConfiguration userConfiguration, Context ctx, Connection con) throws OXException {
        try {
            Queue<FolderObject> q = ((FolderObjectIterator)OXFolderIteratorSQL.getVisibleSubfoldersIterator(9, user.getId(), user.getGroups(), ctx, userConfiguration, null, con)).asQueue();
            int size = q.size();
            Iterator iter = q.iterator();
            ArrayList<FolderObject> l = new ArrayList<FolderObject>(size);
            for (int j = 0; j < size; ++j) {
                FolderObject fobj = (FolderObject)iter.next();
                if (fobj.getObjectID() == 10) {
                    l.add(0, fobj);
                    continue;
                }
                l.add(fobj);
            }
            TIntArrayList subfolderIds = new TIntArrayList(size);
            iter = l.iterator();
            for (int i = 0; i < size; ++i) {
                subfolderIds.add(((FolderObject)iter.next()).getObjectID());
            }
            boolean hasNonTreeVisibleFolders = OXFolderIteratorSQL.hasVisibleFoldersNotSeenInTreeView(8, user.getId(), user.getGroups(), userConfiguration, ctx, con);
            if (hasNonTreeVisibleFolders) {
                subfolderIds.add(14);
            }
            return subfolderIds.toArray();
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
    }

    public static List<String[]> getSystemInfostoreFolderSubfolders(User user, UserConfiguration userConfiguration, Context ctx, boolean altNames, Connection con) throws OXException {
        try {
            Queue<FolderObject> q = ((FolderObjectIterator)OXFolderIteratorSQL.getVisibleSubfoldersIterator(9, user.getId(), user.getGroups(), ctx, userConfiguration, null, con)).asQueue();
            int size = q.size();
            Iterator iter = q.iterator();
            ArrayList<FolderObject> l = new ArrayList<FolderObject>(size);
            for (int j = 0; j < size; ++j) {
                FolderObject fobj = (FolderObject)iter.next();
                if (fobj.getObjectID() == 10) {
                    l.add(0, fobj);
                    continue;
                }
                l.add(fobj);
            }
            StringHelper sh = StringHelper.valueOf(user.getLocale());
            ArrayList<String[]> subfolderIds = new ArrayList<String[]>(size);
            Iterator iter2 = l.iterator();
            for (int i = 0; i < size; ++i) {
                FolderObject fo = (FolderObject)iter2.next();
                int fuid = fo.getObjectID();
                if (fuid == 10) {
                    subfolderIds.add(SystemInfostoreFolder.toArray(String.valueOf(fuid), sh.getString(altNames ? "Shared files" : "Userstore")));
                    continue;
                }
                if (fuid == 15) {
                    subfolderIds.add(SystemInfostoreFolder.toArray(String.valueOf(fuid), sh.getString(altNames ? "Public files" : "Public infostore")));
                    continue;
                }
                subfolderIds.add(SystemInfostoreFolder.toArray(String.valueOf(fuid), fo.getFolderName()));
            }
            boolean hasNonTreeVisibleFolders = OXFolderIteratorSQL.hasVisibleFoldersNotSeenInTreeView(8, user.getId(), user.getGroups(), userConfiguration, ctx, con);
            if (hasNonTreeVisibleFolders) {
                subfolderIds.add(SystemInfostoreFolder.toArray(String.valueOf(14), sh.getString(altNames ? "Other files" : "Other infostore folders")));
            }
            return subfolderIds;
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private static String[] toArray(String ... values) {
        int length = values.length;
        String[] ret = new String[length];
        System.arraycopy(values, 0, ret, 0, length);
        return values;
    }
}

