/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database;

import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.database.DatabaseFolderStorageUtility;

public final class DatabaseFolderType
implements FolderType {
    private static final String STRING = "DB-Type";
    private static final DatabaseFolderType instance = new DatabaseFolderType();

    public static DatabaseFolderType getInstance() {
        return instance;
    }

    private DatabaseFolderType() {
    }

    @Override
    public boolean servesTreeId(String treeId) {
        return FolderStorage.REAL_TREE_ID.equals(treeId);
    }

    @Override
    public boolean servesFolderId(String folderId) {
        return DatabaseFolderStorageUtility.getUnsignedInteger(folderId) >= 0 || DatabaseFolderStorageUtility.hasSharedPrefix(folderId);
    }

    @Override
    public boolean servesParentId(String parentId) {
        return this.servesFolderId(parentId);
    }

    public String toString() {
        return STRING;
    }
}

