/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.HTTPRequestInputStreamProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.java.Streams;
import com.openexchange.java.UnsynchronizedPushbackReader;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class AJAXRequestDataTools {
    private static final String PARAMETER_ACTION = "action";
    private static final AJAXRequestDataTools INSTANCE = new AJAXRequestDataTools();
    protected static final Pattern SPLIT_CSV = Pattern.compile("\\s*,\\s*");
    private static final Set<String> BOOL_VALS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("true", "1", "yes", "y", "on")));

    public static AJAXRequestDataTools getInstance() {
        return INSTANCE;
    }

    protected AJAXRequestDataTools() {
    }

    public final AJAXRequestData parseRequest(HttpServletRequest req, boolean preferStream, boolean isFileUpload, ServerSession session, String prefix) throws IOException, OXException {
        return this.parseRequest(req, preferStream, isFileUpload, session, prefix, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AJAXRequestData parseRequest(HttpServletRequest req, boolean preferStream, boolean isFileUpload, ServerSession session, String prefix, HttpServletResponse optResp) throws IOException, OXException {
        UnsynchronizedPushbackReader reader;
        AJAXRequestData retval;
        block14: {
            String parameter;
            retval = new AJAXRequestData().setHttpServletResponse(optResp);
            retval.setUserAgent(req.getHeader("user-agent"));
            AJAXRequestDataTools.parseHostName(retval, req, session);
            retval.setMultipart(isFileUpload);
            retval.setHttpServletRequest(req);
            retval.setModule(this.getModule(prefix, req));
            retval.setServletRequestURI(AJAXServlet.getServletSpecificURI(req));
            retval.setPathInfo(req.getPathInfo());
            retval.setAction(this.getAction(req));
            retval.setPrefix(prefix);
            retval.setFormat(req.getParameter("format"));
            Set entrySet = req.getParameterMap().entrySet();
            for (Map.Entry entry : entrySet) {
                retval.putParameter((String)entry.getKey(), ((String[])entry.getValue())[0]);
            }
            String eTag = req.getHeader("If-None-Match");
            if (null != eTag) {
                retval.setETag(eTag);
            }
            if (null != (parameter = req.getParameter("decorators"))) {
                for (String id : SPLIT_CSV.split(parameter, 0)) {
                    retval.addDecoratorId(id.trim());
                }
            }
            if (preferStream || AJAXRequestDataTools.parseBoolParameter("binary", req)) {
                retval.setUploadStreamProvider(new HTTPRequestInputStreamProvider(req));
                return retval;
            }
            reader = null;
            try {
                reader = new UnsynchronizedPushbackReader(AJAXServlet.getReaderFor(req));
                int read = reader.read();
                if (read < 0) {
                    retval.setData(null);
                    String data = req.getParameter("data");
                    if (data == null || data.length() <= 0) break block14;
                    try {
                        char c = data.charAt(0);
                        if ('[' == c || '{' == c) {
                            retval.setData(JSONObject.parse((Reader)new StringReader(data)));
                            break block14;
                        }
                        retval.setData(data);
                    }
                    catch (JSONException e) {
                        retval.setData(data);
                    }
                    break block14;
                }
                char c = (char)read;
                reader.unread((int)c);
                if ('[' == c || '{' == c) {
                    try {
                        retval.setData(JSONObject.parse((Reader)reader));
                    }
                    catch (JSONException e) {
                        retval.setData(AJAXServlet.readFrom((Reader)reader));
                    }
                    break block14;
                }
                retval.setData(AJAXServlet.readFrom((Reader)reader));
            }
            catch (Throwable throwable) {
                Streams.close(reader);
                throw throwable;
            }
        }
        Streams.close((Closeable)reader);
        return retval;
    }

    private static boolean parseBoolParameter(String name, HttpServletRequest req) {
        return AJAXRequestDataTools.parseBoolParameter(req.getParameter(name));
    }

    public static boolean parseBoolParameter(String name, AJAXRequestData requestData) {
        return AJAXRequestDataTools.parseBoolParameter(requestData.getParameter(name));
    }

    public static boolean parseBoolParameter(String parameter) {
        return null != parameter && BOOL_VALS.contains(AJAXRequestDataTools.toLowerCase(parameter.trim()));
    }

    public static void parseHostName(AJAXRequestData request, HttpServletRequest req, ServerSession session) {
        request.setSecure(Tools.considerSecure(req));
        HostnameService hostnameService = ServerServiceRegistry.getInstance().getService(HostnameService.class);
        if (null == hostnameService) {
            request.setHostname(req.getServerName());
        } else {
            String hn = hostnameService.getHostname(session.getUserId(), session.getContextId());
            request.setHostname(null == hn ? req.getServerName() : hn);
        }
        request.setRemoteAddress(req.getRemoteAddr());
        request.setRoute(Tools.getRoute(req.getSession(true).getId()));
    }

    private static boolean startsWith(char startingChar, String toCheck) {
        if (null == toCheck) {
            return false;
        }
        int len = toCheck.length();
        if (len <= 0) {
            return false;
        }
        int i = 0;
        if (Character.isWhitespace(toCheck.charAt(i))) {
            while (++i < len && Character.isWhitespace(toCheck.charAt(i))) {
            }
        }
        if (i >= len) {
            return false;
        }
        return startingChar == toCheck.charAt(i);
    }

    public String getModule(String prefix, HttpServletRequest req) {
        int mlen;
        String module;
        String pathInfo = req.getRequestURI();
        int lastIndex = pathInfo.lastIndexOf(59);
        if (lastIndex > 0) {
            pathInfo = pathInfo.substring(0, lastIndex);
        }
        if ('/' == (module = pathInfo.substring(prefix.length())).charAt(mlen = module.length() - 1)) {
            module = module.substring(0, mlen);
        }
        return module;
    }

    public String getAction(HttpServletRequest req) {
        String action = req.getParameter(PARAMETER_ACTION);
        if (null == action) {
            return AJAXRequestDataTools.toUpperCase(req.getMethod());
        }
        return action;
    }

    private static String toUpperCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'a' && c <= 'z' ? (char)(c & 0x5F) : c);
        }
        return builder.toString();
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }
}

