/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.request;

import com.openexchange.ajax.parser.DataParser;
import com.openexchange.api2.RdbLinkSQLInterface;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.LinkObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public class LinkRequest {
    private static final String PARAMETER_MODULE = "module";
    private final Session session;
    private final User user;
    private final JSONWriter jsonWriter;
    private final Context ctx;

    public LinkRequest(Session session, Writer pw, Context ctx) {
        this.session = session;
        this.jsonWriter = new JSONWriter(pw);
        this.ctx = ctx;
        this.user = UserStorage.getStorageUser(session.getUserId(), ctx);
    }

    public void action(String action, JSONObject jsonObject) throws OXException, JSONException {
        if (action.equalsIgnoreCase("all")) {
            this.actionAll(jsonObject);
        } else if (action.equalsIgnoreCase("new")) {
            this.actionNew(jsonObject);
        } else if (action.equalsIgnoreCase("delete")) {
            this.actionDelete(jsonObject);
        } else {
            throw AjaxExceptionCodes.UNKNOWN_ACTION.create(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionAll(JSONObject jsonObj) throws JSONException, OXException, OXException, OXException {
        int id = DataParser.checkInt(jsonObj, "id");
        int folder = DataParser.checkInt(jsonObj, "folder");
        int type = DataParser.checkInt(jsonObj, PARAMETER_MODULE);
        int user = this.user.getId();
        int[] group = this.user.getGroups();
        RdbLinkSQLInterface linksql = new RdbLinkSQLInterface();
        HashSet<LinkObject> availableLinks = new HashSet<LinkObject>();
        LinkObject[] lo = linksql.getLinksOfObject(id, type, folder, user, group, this.session);
        if (lo != null && lo.length > 0) {
            availableLinks.addAll(Arrays.asList(lo));
        }
        if ((lo = linksql.getLinksByObjectID(id, type, user, group, this.session)) != null && lo.length > 0) {
            availableLinks.addAll(Arrays.asList(lo));
        }
        if (availableLinks.isEmpty()) {
            this.jsonWriter.array();
            this.jsonWriter.endArray();
            return;
        }
        this.jsonWriter.array();
        try {
            int size = availableLinks.size();
            Iterator iter = availableLinks.iterator();
            for (int i = 0; i < size; ++i) {
                LinkObject lol = (LinkObject)iter.next();
                if (lol == null) continue;
                this.jsonWriter.object();
                this.jsonWriter.key("id1").value((long)lol.getFirstId());
                this.jsonWriter.key("module1").value((long)lol.getFirstType());
                this.jsonWriter.key("folder1").value((long)lol.getFirstFolder());
                this.jsonWriter.key("id2").value((long)lol.getSecondId());
                this.jsonWriter.key("module2").value((long)lol.getSecondType());
                this.jsonWriter.key("folder2").value((long)lol.getSecondFolder());
                this.jsonWriter.endObject();
            }
        }
        finally {
            this.jsonWriter.endArray();
        }
    }

    public void actionNew(JSONObject jsonObj) throws JSONException, OXException, OXException {
        LinkObject lo = new LinkObject();
        int user = this.user.getId();
        int[] group = this.user.getGroups();
        JSONObject jData = DataParser.checkJSONObject(jsonObj, "data");
        if (jData.has("id1")) {
            lo.setFirstId(jData.getInt("id1"));
        }
        if (jData.has("module1")) {
            lo.setFirstType(jData.getInt("module1"));
        }
        if (jData.has("folder1")) {
            lo.setFirstFolder(jData.getInt("folder1"));
        }
        if (jData.has("id2")) {
            lo.setSecondId(jData.getInt("id2"));
        }
        if (jData.has("module2")) {
            lo.setSecondType(jData.getInt("module2"));
        }
        if (jData.has("folder2")) {
            lo.setSecondFolder(jData.getInt("folder2"));
        }
        lo.setContext(this.ctx.getContextId());
        RdbLinkSQLInterface linksql = new RdbLinkSQLInterface();
        linksql.saveLink(lo, user, group, this.session);
        this.jsonWriter.object();
        this.jsonWriter.key("data").value((Object)"");
        this.jsonWriter.endObject();
    }

    public void actionDelete(JSONObject jsonObj) throws JSONException, OXException {
        int id = DataParser.checkInt(jsonObj, "id");
        int folder = DataParser.checkInt(jsonObj, "folder");
        int type = DataParser.checkInt(jsonObj, PARAMETER_MODULE);
        int user = this.user.getId();
        int[] group = this.user.getGroups();
        JSONObject jData = DataParser.checkJSONObject(jsonObj, "data");
        JSONArray jo = jData.getJSONArray("data");
        int[][] del = new int[jo.length()][3];
        for (int i = 0; i < jo.length(); ++i) {
            JSONArray dl = jo.getJSONArray(i);
            del[i][0] = dl.getInt(0);
            del[i][1] = dl.getInt(1);
            del[i][2] = dl.getInt(2);
        }
        RdbLinkSQLInterface linksql = new RdbLinkSQLInterface();
        int[][] rep = linksql.deleteLinks(id, type, folder, del, user, group, this.session);
        this.jsonWriter.array();
        JSONArray jo2 = new JSONArray();
        for (int i = 0; i < rep.length; ++i) {
            jo2.put(0, rep[i][0]);
            jo2.put(1, rep[i][1]);
            jo2.put(2, rep[i][2]);
            this.jsonWriter.value((Object)jo2);
            jo2.reset();
        }
        this.jsonWriter.endArray();
    }
}

