/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.parser;

import com.openexchange.ajax.parser.CalendarParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.Mapping;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.server.services.I18nServices;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskParser
extends CalendarParser {
    public TaskParser(TimeZone timeZone) {
        super(timeZone);
    }

    public TaskParser(boolean parseAll, TimeZone timeZone) {
        super(parseAll, timeZone);
    }

    public void parse(Task taskobject, JSONObject jsonobject, Locale locale) throws OXException {
        try {
            this.parseElementTask(taskobject, jsonobject, locale);
        }
        catch (OXException e) {
            throw e;
        }
        catch (Exception e) {
            throw OXJSONExceptionCodes.JSON_READ_ERROR.create(e, e.getMessage());
        }
    }

    protected void parseElementTask(Task taskobject, JSONObject json, Locale locale) throws JSONException, OXException {
        if (json.has("start_date")) {
            taskobject.setStartDate(TaskParser.parseDate(json, "start_date"));
        }
        if (json.has("end_date")) {
            taskobject.setEndDate(TaskParser.parseDate(json, "end_date"));
        }
        if (json.has("status")) {
            taskobject.setStatus(TaskParser.parseInt(json, "status"));
        }
        if (json.has("actual_costs")) {
            try {
                taskobject.setActualCosts(TaskParser.parseFloat(json, "actual_costs"));
            }
            catch (OXException e) {
                throw TaskParser.handleParseException(e, TaskParser.parseString(json, "actual_costs"), 302, locale);
            }
        }
        if (json.has("actual_duration")) {
            try {
                taskobject.setActualDuration(TaskParser.parseLong(json, "actual_duration"));
            }
            catch (OXException e) {
                throw TaskParser.handleParseException(e, TaskParser.parseString(json, "actual_duration"), 303, locale);
            }
        }
        if (json.has("percent_completed")) {
            taskobject.setPercentComplete(TaskParser.parseInt(json, "percent_completed"));
        }
        if (json.has("date_completed")) {
            taskobject.setDateCompleted(TaskParser.parseDate(json, "date_completed"));
        }
        if (json.has("billing_information")) {
            taskobject.setBillingInformation(TaskParser.parseString(json, "billing_information"));
        }
        if (json.has("target_costs")) {
            try {
                taskobject.setTargetCosts(TaskParser.parseFloat(json, "target_costs"));
            }
            catch (OXException e) {
                throw TaskParser.handleParseException(e, TaskParser.parseString(json, "target_costs"), 307, locale);
            }
        }
        if (json.has("target_duration")) {
            try {
                taskobject.setTargetDuration(TaskParser.parseLong(json, "target_duration"));
            }
            catch (OXException e) {
                throw TaskParser.handleParseException(e, TaskParser.parseString(json, "target_duration"), 308, locale);
            }
        }
        if (json.has("priority")) {
            taskobject.setPriority(TaskParser.parseInt(json, "priority"));
        }
        if (json.has("currency")) {
            taskobject.setCurrency(TaskParser.parseString(json, "currency"));
        }
        if (json.has("trip_meter")) {
            taskobject.setTripMeter(TaskParser.parseString(json, "trip_meter"));
        }
        if (json.has("companies")) {
            taskobject.setCompanies(TaskParser.parseString(json, "companies"));
        }
        if (json.has("alarm")) {
            taskobject.setAlarm(TaskParser.parseTime(json, "alarm", this.timeZone));
        }
        this.parseElementCalendar(taskobject, json);
    }

    private static OXException handleParseException(OXException e, String jsonValue, int attributeId, Locale locale) throws OXException {
        if (OXJSONExceptionCodes.CONTAINS_NON_DIGITS.equals(e) || OXJSONExceptionCodes.INVALID_VALUE.equals(e)) {
            throw TaskExceptionCode.CONTAINS_NON_DIGITS.create(e, jsonValue, TaskParser.translate(locale, Mapping.getMapping(attributeId).getDisplayName()));
        }
        throw e;
    }

    private static String translate(Locale locale, String attributeName) {
        return I18nServices.getInstance().translate(locale, attributeName);
    }
}

