/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.parser;

import com.openexchange.ajax.parser.DataParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class ReminderParser
extends DataParser {
    public ReminderParser(TimeZone timeZone) {
        super(timeZone);
    }

    public void parse(ReminderObject reminder, JSONObject json) throws OXException {
        try {
            this.parseElementReminder(reminder, json);
        }
        catch (JSONException e) {
            throw OXJSONExceptionCodes.JSON_READ_ERROR.create(e, json.toString());
        }
    }

    protected void parseElementReminder(ReminderObject reminder, JSONObject json) throws JSONException, OXException {
        if (json.has("last_modified")) {
            reminder.setLastModified(ReminderParser.parseDate(json, "last_modified"));
        }
        if (json.has("target_id")) {
            reminder.setTargetId(ReminderParser.parseInt(json, "target_id"));
        }
        if (json.has("folder")) {
            reminder.setFolder(ReminderParser.parseInt(json, "folder"));
        }
        if (json.has("alarm")) {
            reminder.setDate(ReminderParser.parseTime(json, "alarm", this.getTimeZone()));
        }
        if (json.has("module")) {
            reminder.setModule(ReminderParser.parseInt(json, "module"));
        }
        if (json.has("user_id")) {
            reminder.setUser(ReminderParser.parseInt(json, "user_id"));
        }
        if (json.has("recurrence_appointment")) {
            reminder.setRecurrenceAppointment(ReminderParser.parseBoolean(json, "recurrence_appointment"));
        }
        if (json.has("id")) {
            reminder.setObjectId(ReminderParser.parseInt(json, "id"));
        }
    }
}

