/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.parser;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.AbstractFolder;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.internal.CalculatePermission;
import com.openexchange.folderstorage.messaging.MessagingFolderIdentifier;
import com.openexchange.folderstorage.messaging.contentType.MessagingContentType;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.messaging.DefaultMessagingFolder;
import com.openexchange.messaging.DefaultMessagingPermission;
import com.openexchange.messaging.MessagingExceptionCodes;
import com.openexchange.session.Session;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MessagingFolderParser {
    private static final int[] mapping = new int[]{0, 2, 4, -1, 8};

    private MessagingFolderParser() {
    }

    public static void parse(JSONObject jsonObj, DefaultMessagingFolder messagingFolder, Session session) throws OXException {
        block19: {
            try {
                JSONArray jsonArr;
                int len;
                if (jsonObj.has("title")) {
                    messagingFolder.setName(jsonObj.getString("title"));
                }
                if (jsonObj.has("folder_id")) {
                    MessagingFolderIdentifier mfi = new MessagingFolderIdentifier(jsonObj.getString("folder_id"));
                    messagingFolder.setParentId(mfi.getFullname());
                }
                if (jsonObj.has("module") && !jsonObj.getString("module").equalsIgnoreCase("messaging")) {
                    throw MessagingExceptionCodes.MISSING_PARAMETER.create(new Object[]{"module"});
                }
                if (jsonObj.hasAndNotNull("subscribed")) {
                    try {
                        messagingFolder.setSubscribed(jsonObj.getInt("subscribed") > 0);
                    }
                    catch (JSONException e) {
                        messagingFolder.setSubscribed(jsonObj.getBoolean("subscribed"));
                    }
                }
                if (!jsonObj.hasAndNotNull("permissions") || (len = (jsonArr = jsonObj.getJSONArray("permissions")).length()) <= 0) break block19;
                ArrayList<DefaultMessagingPermission> mailPerms = new ArrayList<DefaultMessagingPermission>(len);
                UserStorage us = UserStorage.getInstance();
                for (int i = 0; i < len; ++i) {
                    int entity;
                    JSONObject elem = jsonArr.getJSONObject(i);
                    if (!elem.has("entity")) {
                        throw MessagingExceptionCodes.MISSING_PARAMETER.create(new Object[]{"entity"});
                    }
                    try {
                        entity = elem.getInt("entity");
                    }
                    catch (JSONException e) {
                        String entityStr = elem.getString("entity");
                        entity = us.getUserId(entityStr, ContextStorage.getStorageContext(session.getContextId()));
                    }
                    DefaultMessagingPermission dmp = DefaultMessagingPermission.newInstance();
                    dmp.setEntity(entity);
                    if (!elem.has("bits")) {
                        throw MessagingExceptionCodes.MISSING_PARAMETER.create(new Object[]{"bits"});
                    }
                    int[] permissionBits = MessagingFolderParser.parsePermissionBits(elem.getInt("bits"));
                    dmp.setAllPermissions(permissionBits[0], permissionBits[1], permissionBits[2], permissionBits[3]);
                    dmp.setAdmin(permissionBits[4] > 0);
                    if (!elem.has("group")) {
                        throw MessagingExceptionCodes.MISSING_PARAMETER.create(new Object[]{"group"});
                    }
                    dmp.setGroup(elem.getBoolean("group"));
                    mailPerms.add(dmp);
                }
                messagingFolder.setPermissions(mailPerms);
            }
            catch (JSONException e) {
                throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (OXException e) {
                throw e;
            }
        }
    }

    static int[] parsePermissionBits(int bitsArg) {
        int bits = bitsArg;
        int[] retval = new int[5];
        for (int i = retval.length - 1; i >= 0; --i) {
            int shiftVal = i * 7;
            retval[i] = bits >> shiftVal;
            bits -= retval[i] << shiftVal;
            retval[i] = retval[i] == 64 ? 128 : (i < retval.length - 1 ? mapping[retval[i]] : retval[i]);
        }
        return retval;
    }

    public static final class ParsedMessagingFolder
    extends AbstractFolder {
        private static final long serialVersionUID = -2941835670844893577L;

        @Override
        public boolean isGlobalID() {
            return false;
        }

        public void parse(JSONObject folderJsonObject) throws OXException {
            try {
                if (folderJsonObject.hasAndNotNull("id")) {
                    this.setID(folderJsonObject.getString("id"));
                }
                if (folderJsonObject.hasAndNotNull("folder_id")) {
                    this.setParentID(folderJsonObject.getString("folder_id"));
                }
                if (folderJsonObject.hasAndNotNull("title")) {
                    this.setName(folderJsonObject.getString("title"));
                }
                this.setContentType(MessagingContentType.getInstance());
                if (folderJsonObject.hasAndNotNull("subscribed")) {
                    try {
                        this.setSubscribed(folderJsonObject.getInt("subscribed") > 0);
                    }
                    catch (JSONException e) {
                        this.setSubscribed(folderJsonObject.getBoolean("subscribed"));
                    }
                } else {
                    this.setSubscribed(true);
                }
                if (folderJsonObject.hasAndNotNull("permissions")) {
                    JSONArray jsonArr = folderJsonObject.getJSONArray("permissions");
                    Permission[] permissions = ParsedMessagingFolder.parsePermission(jsonArr);
                    this.setPermissions(permissions);
                }
            }
            catch (JSONException e) {
                throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }

        public static Permission[] parsePermission(JSONArray permissionsAsJSON) throws OXException {
            try {
                int numberOfPermissions = permissionsAsJSON.length();
                Permission[] perms = new Permission[numberOfPermissions];
                for (int i = 0; i < numberOfPermissions; ++i) {
                    JSONObject elem = permissionsAsJSON.getJSONObject(i);
                    if (!elem.hasAndNotNull("entity")) {
                        throw MessagingExceptionCodes.MISSING_PARAMETER.create(new Object[]{"entity"});
                    }
                    int entity = elem.getInt("entity");
                    CalculatePermission.DummyPermission oclPerm = new CalculatePermission.DummyPermission();
                    oclPerm.setEntity(entity);
                    if (!elem.has("bits")) {
                        throw MessagingExceptionCodes.MISSING_PARAMETER.create(new Object[]{"bits"});
                    }
                    int[] permissionBits = MessagingFolderParser.parsePermissionBits(elem.getInt("bits"));
                    oclPerm.setFolderPermission(permissionBits[0]);
                    oclPerm.setReadPermission(permissionBits[1]);
                    oclPerm.setWritePermission(permissionBits[2]);
                    oclPerm.setDeletePermission(permissionBits[3]);
                    oclPerm.setAdmin(permissionBits[4] > 0);
                    if (!elem.has("group")) {
                        throw MessagingExceptionCodes.MISSING_PARAMETER.create(new Object[]{"group"});
                    }
                    oclPerm.setGroup(elem.getBoolean("group"));
                    perms[i] = oclPerm;
                }
                return perms;
            }
            catch (JSONException e) {
                throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }
    }
}

