/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic.osgi;

import com.openexchange.caching.CacheService;
import com.openexchange.context.ContextService;
import com.openexchange.crypto.CryptoService;
import com.openexchange.database.CreateTableService;
import com.openexchange.database.DatabaseService;
import com.openexchange.datatypes.genericonf.storage.GenericConfigurationStorageService;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTaskProviderService;
import com.openexchange.log.Log;
import com.openexchange.messaging.MessagingService;
import com.openexchange.messaging.generic.groupware.MessagingGenericCreateTableTask;
import com.openexchange.messaging.generic.groupware.MessagingGenericDeleteListener;
import com.openexchange.messaging.generic.internal.CachingMessagingAccountStorage;
import com.openexchange.messaging.generic.secret.MessagingSecretHandling;
import com.openexchange.messaging.generic.services.MessagingGenericServiceRegistry;
import com.openexchange.messaging.registry.MessagingServiceRegistry;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.secret.osgi.tools.WhiteboardSecretService;
import com.openexchange.secret.recovery.EncryptedItemCleanUpService;
import com.openexchange.secret.recovery.EncryptedItemDetectorService;
import com.openexchange.secret.recovery.SecretMigrator;
import com.openexchange.server.ServiceLookup;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.osgi.util.tracker.ServiceTracker;

public class MessagingGenericActivator
extends HousekeepingActivator {
    private WhiteboardSecretService secretService;

    protected Class<?>[] getNeededServices() {
        return new Class[]{DatabaseService.class, GenericConfigurationStorageService.class, ContextService.class, MessagingServiceRegistry.class, CacheService.class, CryptoService.class};
    }

    protected void startBundle() throws Exception {
        try {
            MessagingGenericServiceRegistry.REF.set((ServiceLookup)this);
            String regionName = CachingMessagingAccountStorage.getRegionName();
            byte[] ccf = ("jcs.region." + regionName + "=LTCP\n" + "jcs.region." + regionName + ".cacheattributes=org.apache.jcs.engine.CompositeCacheAttributes\n" + "jcs.region." + regionName + ".cacheattributes.MaxObjects=10000000\n" + "jcs.region." + regionName + ".cacheattributes.MemoryCacheName=org.apache.jcs.engine.memory.lru.LRUMemoryCache\n" + "jcs.region." + regionName + ".cacheattributes.UseMemoryShrinker=true\n" + "jcs.region." + regionName + ".cacheattributes.MaxMemoryIdleTimeSeconds=180\n" + "jcs.region." + regionName + ".cacheattributes.ShrinkerIntervalSeconds=60\n" + "jcs.region." + regionName + ".elementattributes=org.apache.jcs.engine.ElementAttributes\n" + "jcs.region." + regionName + ".elementattributes.IsEternal=false\n" + "jcs.region." + regionName + ".elementattributes.MaxLifeSeconds=300\n" + "jcs.region." + regionName + ".elementattributes.IdleTime=180\n" + "jcs.region." + regionName + ".elementattributes.IsSpool=false\n" + "jcs.region." + regionName + ".elementattributes.IsRemote=false\n" + "jcs.region." + regionName + ".elementattributes.IsLateral=false\n").getBytes();
            ((CacheService)this.getService(CacheService.class)).loadConfiguration((InputStream)new ByteArrayInputStream(ccf));
            final ServiceTracker messagingServiceTracker = new ServiceTracker(this.context, MessagingService.class, null);
            this.rememberTracker(messagingServiceTracker);
            this.openTrackers();
            final MessagingGenericCreateTableTask createTableTask = new MessagingGenericCreateTableTask();
            this.registerService(UpdateTaskProviderService.class.getName(), new UpdateTaskProviderService(){

                public Collection<UpdateTask> getUpdateTasks() {
                    return Arrays.asList(new UpdateTask[]{createTableTask});
                }
            });
            this.registerService(CreateTableService.class, (Object)createTableTask, null);
            this.registerService(DeleteListener.class, new MessagingGenericDeleteListener(), null);
            MessagingSecretHandling secretHandling = new MessagingSecretHandling(){

                @Override
                protected Collection<MessagingService> getMessagingServices() {
                    Object[] objects = messagingServiceTracker.getServices();
                    if (objects == null) {
                        return Collections.emptyList();
                    }
                    ArrayList<MessagingService> list = new ArrayList<MessagingService>(objects.length);
                    for (Object o : objects) {
                        list.add((MessagingService)o);
                    }
                    return list;
                }
            };
            this.registerService(EncryptedItemDetectorService.class, secretHandling);
            this.registerService(SecretMigrator.class, secretHandling);
            this.registerService(EncryptedItemCleanUpService.class, secretHandling);
        }
        catch (Exception e) {
            Log.loggerFor(MessagingGenericActivator.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected void stopBundle() throws Exception {
        try {
            CacheService cacheService = (CacheService)this.getService(CacheService.class);
            if (null != cacheService) {
                cacheService.freeCache(CachingMessagingAccountStorage.getRegionName());
            }
            this.cleanUp();
            MessagingGenericServiceRegistry.REF.set(null);
            WhiteboardSecretService secretService = this.secretService;
            if (null != secretService) {
                secretService.close();
                this.secretService = null;
            }
        }
        catch (Exception e) {
            Log.loggerFor(MessagingGenericActivator.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

