/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.log;

import com.openexchange.log.Log;
import com.openexchange.log.LogProperties;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class Props {
    private static final org.apache.commons.logging.Log LOG = Log.loggerFor(Props.class);
    private final EnumMap<LogProperties.Name, Object> map;
    private final Set<LogProperties.Name> keys;

    protected Props() {
        this.map = new EnumMap(LogProperties.Name.class);
        this.keys = this.map.keySet();
    }

    protected Props(Props other) {
        this.map = new EnumMap<LogProperties.Name, Object>(other.map);
        this.keys = this.map.keySet();
    }

    public String toString() {
        return this.map.toString();
    }

    public Map<LogProperties.Name, Object> getMap() {
        return this.map;
    }

    public Map<String, Object> asMap() {
        return this.asMap(false);
    }

    public Map<String, Object> asMap(boolean sorted) {
        TreeMap<String, Object> m = sorted ? new TreeMap() : new HashMap(this.map.size());
        for (Map.Entry<LogProperties.Name, Object> entry : this.map.entrySet()) {
            m.put(entry.getKey().getName(), entry.getValue());
        }
        return m;
    }

    public boolean contains(LogProperties.Name name) {
        return this.map.containsKey((Object)name);
    }

    public <V> V get(String sName) {
        LogProperties.Name name = LogProperties.Name.nameFor(sName);
        if (null == name) {
            return null;
        }
        try {
            return this.get(name);
        }
        catch (ClassCastException e) {
            LOG.warn((Object)"Type mismatch", (Throwable)e);
            return null;
        }
    }

    public <V> V get(LogProperties.Name name) {
        try {
            return (V)this.map.get((Object)name);
        }
        catch (ClassCastException e) {
            LOG.warn((Object)"Type mismatch", (Throwable)e);
            return null;
        }
    }

    public <V> boolean put(LogProperties.Name name, V value) {
        if (null == name) {
            return false;
        }
        if (null == value) {
            return null != this.map.remove((Object)name);
        }
        return null != this.map.put(name, value);
    }

    public void remove(LogProperties.Name name) {
        if (null != name) {
            this.map.remove(name.getName());
        }
    }

    public void remove(Collection<LogProperties.Name> names) {
        if (null != names) {
            this.keys.removeAll(names);
        }
    }

    public Props copy() {
        return new Props(this);
    }
}

