/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.log;

import com.openexchange.java.StringAllocator;
import com.openexchange.log.ForceLog;
import com.openexchange.log.Log;
import com.openexchange.log.LogProperties;
import com.openexchange.log.LogPropertyName;
import com.openexchange.log.PropertiesAppender;
import com.openexchange.log.Props;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PropertiesAppendingLogWrapper
implements org.apache.commons.logging.Log,
PropertiesAppender {
    private final String lineSeparator;
    private final org.apache.commons.logging.Log delegate;
    private final boolean enabled = LogProperties.isEnabled();
    private final boolean delegateAppending;

    protected PropertiesAppendingLogWrapper(org.apache.commons.logging.Log delegate) {
        this.lineSeparator = System.getProperty("line.separator");
        this.delegate = delegate;
        this.delegateAppending = delegate instanceof com.openexchange.exception.Log || delegate instanceof Log;
    }

    public void debug(Object message, Throwable t) {
        this.delegate.debug(this.appendProperties(message, LogPropertyName.LogLevel.DEBUG), t);
    }

    public void debug(Object message) {
        this.delegate.debug(this.appendProperties(message, LogPropertyName.LogLevel.DEBUG));
    }

    public void error(Object message, Throwable t) {
        this.delegate.error(this.appendProperties(message, LogPropertyName.LogLevel.ERROR), t);
    }

    public void error(Object message) {
        this.delegate.error(this.appendProperties(message, LogPropertyName.LogLevel.ERROR));
    }

    public void fatal(Object message, Throwable t) {
        this.delegate.fatal(this.appendProperties(message, LogPropertyName.LogLevel.FATAL), t);
    }

    public void fatal(Object message) {
        this.delegate.fatal(this.appendProperties(message, LogPropertyName.LogLevel.FATAL));
    }

    public void info(Object message, Throwable t) {
        this.delegate.info(this.appendProperties(message, LogPropertyName.LogLevel.INFO), t);
    }

    public void info(Object message) {
        this.delegate.info(this.appendProperties(message, LogPropertyName.LogLevel.INFO));
    }

    public void trace(Object message, Throwable t) {
        this.delegate.trace(this.appendProperties(message, LogPropertyName.LogLevel.TRACE), t);
    }

    public void trace(Object message) {
        this.delegate.trace(this.appendProperties(message, LogPropertyName.LogLevel.TRACE));
    }

    public void warn(Object message, Throwable t) {
        this.delegate.warn(this.appendProperties(message, LogPropertyName.LogLevel.WARNING), t);
    }

    public void warn(Object message) {
        this.delegate.warn(this.appendProperties(message, LogPropertyName.LogLevel.WARNING));
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.delegate.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    @Override
    public Object appendProperties(Object message, LogPropertyName.LogLevel logLevel) {
        if (!this.enabled) {
            return message;
        }
        if (this.delegateAppending) {
            return new PropertiesAppendingMessage(message, logLevel, this);
        }
        return this.innerAppendProperties(message, logLevel);
    }

    protected Object innerAppendProperties(Object message, LogPropertyName.LogLevel logLevel) {
        Set<LogProperties.Name> propertiesToLog = this.getPropertiesFor(logLevel);
        if (propertiesToLog.isEmpty()) {
            return message;
        }
        Props logProps = LogProperties.optLogProperties();
        if (logProps == null) {
            return message;
        }
        Map<LogProperties.Name, Object> properties = logProps.getMap();
        if (properties == null) {
            return message;
        }
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        boolean isEmpty = true;
        for (LogProperties.Name propertyName : propertiesToLog) {
            Object value = properties.get((Object)propertyName);
            if (null == value) continue;
            sorted.put(propertyName.getName(), value.toString());
            isEmpty = false;
        }
        StringAllocator sb = new StringAllocator(256);
        if (!isEmpty) {
            String lineSeparator = this.lineSeparator;
            boolean first = true;
            for (Map.Entry entry : sorted.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(lineSeparator);
                }
                sb.append((String)entry.getKey()).append('=').append((String)entry.getValue());
            }
            sb.append(lineSeparator).append(lineSeparator);
        }
        sb.append(message);
        return sb.toString();
    }

    @Override
    public Set<LogProperties.Name> getPropertiesFor(LogPropertyName.LogLevel logLevel) {
        Set<LogProperties.Name> propertiesToLog;
        if (!this.enabled) {
            return Collections.emptySet();
        }
        Props logProps = LogProperties.optLogProperties();
        if (logProps == null) {
            return Collections.emptySet();
        }
        Map<LogProperties.Name, Object> properties = logProps.getMap();
        if (properties == null) {
            return Collections.emptySet();
        }
        List<LogPropertyName> names = LogProperties.getPropertyNames();
        if (names.isEmpty()) {
            propertiesToLog = Collections.emptySet();
        } else {
            propertiesToLog = EnumSet.noneOf(LogProperties.Name.class);
            for (LogPropertyName name : names) {
                if (!name.implies(logLevel)) continue;
                propertiesToLog.add(name.getPropertyName());
            }
        }
        for (Map.Entry<LogProperties.Name, Object> entry : properties.entrySet()) {
            LogProperties.Name propertyName = entry.getKey();
            if (propertiesToLog.contains((Object)propertyName) || !(entry.getValue() instanceof ForceLog)) continue;
            propertiesToLog.add(propertyName);
        }
        return propertiesToLog;
    }

    private static final class PropertiesAppendingMessage
    implements PropertiesAppender {
        final Object message;
        final PropertiesAppendingLogWrapper appender;
        final LogPropertyName.LogLevel logLevel;

        PropertiesAppendingMessage(Object message, LogPropertyName.LogLevel logLevel, PropertiesAppendingLogWrapper appender) {
            this.message = message;
            this.appender = appender;
            this.logLevel = logLevel;
        }

        public String toString() {
            return this.appendProperties(this.message, this.logLevel).toString();
        }

        @Override
        public Object appendProperties(Object message, LogPropertyName.LogLevel logLevel) {
            return this.appender.innerAppendProperties(message, logLevel);
        }

        @Override
        public Set<LogProperties.Name> getPropertiesFor(LogPropertyName.LogLevel logLevel) {
            return this.appender.getPropertiesFor(logLevel);
        }
    }
}

