/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.storagesconsistency;

import com.openexchange.exception.OXException;
import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.IndexRange;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.permission.MailPermission;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import java.util.HashSet;

public final class MailStoragesConsistencyTest
extends AbstractMailTest {
    private static final String TEMPORARY_FOLDER = "TemporaryFolder";
    private static final String INBOX = "INBOX";
    private static final MailField[] FIELDS_ID = new MailField[]{MailField.ID};

    public MailStoragesConsistencyTest() {
    }

    public MailStoragesConsistencyTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailStoragesConsistency1() {
        try {
            SessionObject session = this.getSession();
            MailAccess mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            String fullname = null;
            try {
                String parentFullname = null;
                MailFolder inbox = mailAccess.getFolderStorage().getFolder(INBOX);
                if (inbox.isHoldsFolders()) {
                    fullname = inbox.getFullname() + inbox.getSeparator() + TEMPORARY_FOLDER;
                    parentFullname = INBOX;
                } else {
                    fullname = TEMPORARY_FOLDER;
                    parentFullname = "default";
                }
                MailFolderDescription mfd = new MailFolderDescription();
                mfd.setExists(false);
                mfd.setParentFullname(parentFullname);
                mfd.setSeparator(inbox.getSeparator());
                mfd.setSubscribed(false);
                mfd.setName(TEMPORARY_FOLDER);
                MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
                p.setEntity(this.getUser());
                p.setAllPermission(128, 128, 128, 128);
                p.setFolderAdmin(true);
                p.setGroupPermission(false);
                mfd.addPermission(p);
                mailAccess.getFolderStorage().createFolder(mfd);
                String[] uids = mailAccess.getMessageStorage().appendMessages(fullname, MailStoragesConsistencyTest.getMessages(this.getTestMailDir(), -1));
                mailAccess.getMessageStorage().copyMessages(fullname, fullname, uids, true);
                mailAccess.getFolderStorage().deleteFolder(fullname, true);
                try {
                    mailAccess.getMessageStorage().getAllMessages(fullname, IndexRange.NULL, null, null, FIELDS_ID);
                }
                catch (OXException e) {
                    if (e.getCause() != null) {
                        e.printStackTrace();
                        MailStoragesConsistencyTest.fail((String)("Folder/message storage inconsistency detected: " + e.getCause().getMessage()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MailStoragesConsistencyTest.fail((String)("Folder/message storage inconsistency detected: " + e.getMessage()));
                }
                finally {
                    fullname = null;
                }
            }
            finally {
                if (fullname != null && mailAccess.getFolderStorage().exists(fullname)) {
                    mailAccess.getFolderStorage().deleteFolder(fullname, true);
                }
                mailAccess.close(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailStoragesConsistencyTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailStoragesConsistency2() {
        try {
            SessionObject session = this.getSession();
            MailAccess mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            String fullname = null;
            String[] trashedIds = null;
            try {
                String parentFullname = null;
                MailFolder inbox = mailAccess.getFolderStorage().getFolder(INBOX);
                if (inbox.isHoldsFolders()) {
                    fullname = inbox.getFullname() + inbox.getSeparator() + TEMPORARY_FOLDER;
                    parentFullname = INBOX;
                } else {
                    fullname = TEMPORARY_FOLDER;
                    parentFullname = "default";
                }
                MailFolderDescription mfd = new MailFolderDescription();
                mfd.setExists(false);
                mfd.setParentFullname(parentFullname);
                mfd.setSeparator(inbox.getSeparator());
                mfd.setSubscribed(false);
                mfd.setName(TEMPORARY_FOLDER);
                MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
                p.setEntity(this.getUser());
                p.setAllPermission(128, 128, 128, 128);
                p.setFolderAdmin(true);
                p.setGroupPermission(false);
                mfd.addPermission(p);
                mailAccess.getFolderStorage().createFolder(mfd);
                String[] uids = mailAccess.getMessageStorage().appendMessages(fullname, MailStoragesConsistencyTest.getMessages(this.getTestMailDir(), -1));
                String trashFullname = mailAccess.getFolderStorage().getTrashFolder();
                int numTrashedMails = this.getMessageCount(mailAccess, trashFullname);
                if (numTrashedMails >= 0) {
                    MailMessage[] trashed = mailAccess.getMessageStorage().getAllMessages(trashFullname, IndexRange.NULL, MailSortField.RECEIVED_DATE, OrderDirection.ASC, FIELDS_ID);
                    MailStoragesConsistencyTest.assertTrue((String)("Size mismatch: " + trashed.length + " but should be " + numTrashedMails), (trashed.length == numTrashedMails ? 1 : 0) != 0);
                    HashSet<String> oldIds = new HashSet<String>(numTrashedMails);
                    for (int i = 0; i < trashed.length; ++i) {
                        oldIds.add(trashed[i].getMailId());
                    }
                    mailAccess.getFolderStorage().clearFolder(fullname);
                    if (!this.getUserSettingMail().isHardDeleteMsgs()) {
                        int i;
                        int expectedMsgCount = numTrashedMails + uids.length;
                        MailStoragesConsistencyTest.assertEquals((String)"Mails not completely moved to trash", (int)expectedMsgCount, (int)this.getMessageCount(mailAccess, trashFullname));
                        trashed = mailAccess.getMessageStorage().getAllMessages(trashFullname, IndexRange.NULL, MailSortField.RECEIVED_DATE, OrderDirection.ASC, FIELDS_ID);
                        MailStoragesConsistencyTest.assertTrue((String)("Size mismatch: " + trashed.length + " but should be " + expectedMsgCount), (trashed.length == expectedMsgCount ? 1 : 0) != 0);
                        HashSet<String> newIds = new HashSet<String>(numTrashedMails);
                        for (i = 0; i < trashed.length; ++i) {
                            newIds.add(trashed[i].getMailId());
                        }
                        newIds.removeAll(oldIds);
                        trashedIds = new String[newIds.size()];
                        i = 0;
                        for (String id : newIds) {
                            trashedIds[i++] = id;
                        }
                        MailStoragesConsistencyTest.assertTrue((String)"Number of new trash mails does not match trashed mails", (trashedIds.length == uids.length ? 1 : 0) != 0);
                    }
                }
            }
            finally {
                if (fullname != null && mailAccess.getFolderStorage().exists(fullname)) {
                    mailAccess.getFolderStorage().deleteFolder(fullname, true);
                }
                if (trashedIds != null) {
                    mailAccess.getMessageStorage().deleteMessages(mailAccess.getFolderStorage().getTrashFolder(), trashedIds, true);
                }
                mailAccess.close(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailStoragesConsistencyTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailStoragesConsistency3() {
        try {
            SessionObject session = this.getSession();
            String fullname = null;
            MailAccess mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            try {
                String parentFullname = null;
                MailFolder inbox = mailAccess.getFolderStorage().getFolder(INBOX);
                if (inbox.isHoldsFolders()) {
                    fullname = inbox.getFullname() + inbox.getSeparator() + TEMPORARY_FOLDER;
                    parentFullname = INBOX;
                } else {
                    fullname = TEMPORARY_FOLDER;
                    parentFullname = "default";
                }
                MailFolderDescription mfd = new MailFolderDescription();
                mfd.setExists(false);
                mfd.setParentFullname(parentFullname);
                mfd.setSeparator(inbox.getSeparator());
                mfd.setSubscribed(false);
                mfd.setName(TEMPORARY_FOLDER);
                MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
                p.setEntity(this.getUser());
                p.setAllPermission(128, 128, 128, 128);
                p.setFolderAdmin(true);
                p.setGroupPermission(false);
                mfd.addPermission(p);
                mailAccess.getFolderStorage().createFolder(mfd);
                MailMessage appendMe = MailStoragesConsistencyTest.getMessages(this.getTestMailDir(), 1)[0];
                String uid = mailAccess.getMessageStorage().appendMessages(fullname, new MailMessage[]{appendMe})[0];
                MailStoragesConsistencyTest.assertNotSame((String)("ID returned by MailMessageStorage.appendMessages() is invalid: " + Long.valueOf(uid)), (Object)-1L, (Object)Long.valueOf(uid));
                MailMessage mm = mailAccess.getMessageStorage().getMessage(fullname, uid, true);
                MailStoragesConsistencyTest.assertNotNull((String)"Returned MailMessage object from MailMessageStorage.getMessage() is null but shouldn't.", (Object)mm);
            }
            finally {
                if (fullname != null && mailAccess.getFolderStorage().exists(fullname)) {
                    mailAccess.getFolderStorage().deleteFolder(fullname, true);
                }
                mailAccess.close(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailStoragesConsistencyTest.fail((String)e.getMessage());
        }
    }
}

