/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.tasks.Mapper;
import com.openexchange.groupware.tasks.Mapping;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.util.TimeZones;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class TestTask
extends Task {
    protected TimeZone timezone;
    public static final int DATES = 1;
    public static final int RECURRENCES = 2;

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
    }

    public Calendar getCalendar() {
        return TimeTools.createCalendar(this.timezone);
    }

    public Calendar getCalendar(Date date) {
        Calendar calendar = this.getCalendar();
        calendar.setTime(date);
        return calendar;
    }

    public TestTask checkConsistencyOf(int ... switches) {
        block4: for (int currentSwitch : switches) {
            switch (currentSwitch) {
                case 1: {
                    if (!this.containsStartDate()) {
                        this.setStartDate(new Date());
                    }
                    if (this.containsStartDate() && !this.containsEndDate()) {
                        this.setEndDate(this.getStartDate());
                    }
                    if (!this.containsStartDate() || !this.containsEndDate() || this.getEndDate().compareTo(this.getStartDate()) >= 0) continue block4;
                    this.setEndDate(this.getStartDate());
                    continue block4;
                }
                case 2: {
                    if (!this.containsRecurrenceType() && !this.containsDays() && !this.containsDayInMonth() && !this.containsInterval() || this.containsInterval()) continue block4;
                    this.setInterval(1);
                }
            }
        }
        return this;
    }

    protected Date dateAtDayOfTheMonth(Date date, int dayOfTheMonth) {
        Calendar time = this.getCalendar();
        time.setTime(date);
        time.set(5, dayOfTheMonth);
        return time.getTime();
    }

    protected Date shiftDateByDays(Date date, int daysToShift) {
        Calendar time = this.getCalendar();
        time.setTime(date);
        time.add(5, daysToShift);
        return time.getTime();
    }

    protected Date setWeekDay(Date date, int weekDay) {
        Calendar time = this.getCalendar();
        time.setTime(date);
        time.set(7, this.ox2CalDay(weekDay));
        return time.getTime();
    }

    protected Date setMonthDay(Date date, int monthDay) {
        Calendar time = this.getCalendar();
        time.setTime(date);
        time.set(5, monthDay);
        return time.getTime();
    }

    protected Date setWeekOfMonth(Date date, int week) {
        Calendar time = this.getCalendar();
        time.setTime(date);
        int wantedMonth = time.get(2);
        time.set(4, 1);
        if (time.get(2) < wantedMonth) {
            time.add(4, 1);
        }
        time.add(4, week - 1);
        return time.getTime();
    }

    public TestTask startsThisWeek(int dayOfWeek) {
        if (!this.containsStartDate()) {
            this.setStartDate(new Date());
        }
        this.setStartDate(this.setWeekDay(this.getStartDate(), dayOfWeek));
        return this;
    }

    public TestTask startsThisMonth(int dayOfMonth) {
        if (!this.containsStartDate()) {
            this.setStartDate(new Date());
        }
        this.setStartDate(this.setMonthDay(this.getStartDate(), dayOfMonth));
        return this;
    }

    public TestTask startsWeekOfMonth(int week) {
        if (!this.containsStartDate()) {
            this.setStartDate(new Date());
        }
        this.setStartDate(this.setWeekOfMonth(this.getStartDate(), week));
        return this;
    }

    public TestTask startsWeekOfMonthOnDay(int week, int dayOfWeek) {
        if (!this.containsStartDate()) {
            this.setStartDate(new Date());
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZones.UTC);
        cal.setTime(this.getStartDate());
        int currentMonth = cal.get(2);
        this.setStartDate(this.setWeekOfMonth(this.setWeekDay(this.getStartDate(), dayOfWeek), week));
        cal.setTime(this.getStartDate());
        int otherMonth = cal.get(2);
        if (otherMonth != currentMonth && (otherMonth < currentMonth || 0 == currentMonth && 11 == otherMonth)) {
            ((Calendar)cal).add(4, 1);
            this.setStartDate(cal.getTime());
        }
        return this;
    }

    public TestTask endsThisWeek(int dayOfWeek) {
        if (!this.containsEndDate()) {
            this.setEndDate(new Date());
        }
        this.setEndDate(this.setWeekDay(this.getEndDate(), dayOfWeek));
        return this;
    }

    public TestTask startsToday() {
        this.setStartDate(new Date());
        return this;
    }

    public TestTask startsTheFollowingDay() {
        if (!this.containsStartDate()) {
            this.setStartDate(new Date());
        }
        this.setStartDate(this.shiftDateByDays(this.getStartDate(), 1));
        return this;
    }

    public TestTask endsTheFollowingDay() {
        if (!this.containsEndDate()) {
            this.setEndDate(new Date());
        }
        this.setEndDate(this.shiftDateByDays(this.getEndDate(), 1));
        return this;
    }

    public TestTask startsTheDayBefore() {
        if (!this.containsStartDate()) {
            this.setStartDate(new Date());
        }
        this.setStartDate(this.shiftDateByDays(this.getStartDate(), -1));
        return this;
    }

    public TestTask endsTheDayBefore() {
        if (!this.containsEndDate()) {
            this.setEndDate(new Date());
        }
        this.setEndDate(this.shiftDateByDays(this.getEndDate(), -1));
        return this;
    }

    protected Date setDayToToday(Date date) {
        Calendar now = this.getCalendar();
        Calendar newDate = this.getCalendar();
        newDate.setTime(date);
        newDate.set(5, now.get(5));
        newDate.set(1, now.get(1));
        newDate.set(2, now.get(2));
        return newDate.getTime();
    }

    public TestTask startsTomorrow() {
        if (!this.containsStartDate()) {
            this.setStartDate(new Date());
        }
        this.setStartDate(this.setDayToToday(this.getStartDate()));
        return this.startsTheFollowingDay();
    }

    public TestTask endsTomorrow() {
        if (!this.containsEndDate()) {
            this.setEndDate(new Date());
        }
        this.setEndDate(this.setDayToToday(this.getEndDate()));
        return this.endsTheFollowingDay();
    }

    public TestTask startsYesterday() {
        if (!this.containsStartDate()) {
            this.setStartDate(new Date());
        }
        this.setStartDate(this.setDayToToday(this.getStartDate()));
        return this.startsTheDayBefore();
    }

    public TestTask endsYesterday() {
        if (!this.containsEndDate()) {
            this.setEndDate(new Date());
        }
        this.setEndDate(this.setDayToToday(this.getEndDate()));
        return this.endsTheDayBefore();
    }

    protected Date dateAtHours(Date date, int hourOfTheDay) {
        Calendar time = this.getCalendar();
        time.setTime(date);
        time.set(11, hourOfTheDay);
        time.set(12, 0);
        return time.getTime();
    }

    public TestTask startsAt(int hourOfTheDay) {
        if (!this.containsStartDate()) {
            this.setStartDate(new Date());
        }
        this.setStartDate(this.dateAtHours(this.getStartDate(), hourOfTheDay));
        return this;
    }

    public TestTask endsAt(int hourOfTheDay) {
        if (!this.containsEndDate()) {
            this.setEndDate(new Date());
        }
        this.setEndDate(this.dateAtHours(this.getEndDate(), hourOfTheDay));
        return this;
    }

    public TestTask startsAtNoon() {
        return this.startsAt(12);
    }

    public TestTask startsInTheMorning() {
        return this.startsAt(6);
    }

    public TestTask startsInTheEvening() {
        return this.startsAt(18);
    }

    public TestTask endsInTheMorning() {
        return this.endsAt(6);
    }

    public TestTask endsAtNoon() {
        return this.endsAt(12);
    }

    public TestTask endsInTheEvening() {
        return this.endsAt(18);
    }

    public TestTask forOneHour() {
        return this;
    }

    public TestTask everyDay() {
        if (!this.containsStartDate()) {
            this.setStartDate(new Date());
        }
        this.setInterval(1);
        return this;
    }

    public TestTask everyWeek() {
        if (!this.containsStartDate()) {
            this.setStartDate(new Date());
        }
        Calendar cal = this.getCalendar(this.getStartDate());
        int dayOfTheWeek = this.cal2OXDay(cal.get(7));
        return this.everyWeekOn(dayOfTheWeek);
    }

    private int cal2OXDay(int calDayOfWeek) {
        return 1 << calDayOfWeek - 1;
    }

    private int ox2CalDay(int oxDayOfWeek) {
        switch (oxDayOfWeek) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 8: {
                return 4;
            }
            case 16: {
                return 5;
            }
            case 32: {
                return 6;
            }
            case 64: {
                return 7;
            }
        }
        throw new IllegalArgumentException();
    }

    public TestTask everyWeekOn(int ... days) {
        if (!this.containsStartDate()) {
            this.setStartDate(new Date());
        }
        int daysOfTheWeek = 0;
        for (int day : days) {
            daysOfTheWeek |= day;
        }
        this.setRecurrenceType(2);
        this.setInterval(1);
        this.setDays(daysOfTheWeek);
        return this;
    }

    public TestTask onDay(int day) {
        this.setDayInMonth(day);
        return this;
    }

    public TestTask onWeekDays(int days) {
        this.setDays(days);
        return this;
    }

    public TestTask inMonth(int month) {
        this.setMonth(month);
        return this;
    }

    public TestTask everyMonth() {
        this.setRecurrenceType(3);
        return this;
    }

    public TestTask everyMonthOnDay(int dayOfMonth) {
        return this.everyMonthOnNthWeekday(dayOfMonth, 127);
    }

    public TestTask everyMonthOnNthWeekday(int n, int weekDay) {
        this.everyMonth();
        this.onDay(n);
        this.onWeekDays(weekDay);
        if (!this.containsInterval()) {
            this.setInterval(1);
        }
        return this;
    }

    public TestTask everyOtherMonth() {
        this.setRecurrenceType(3);
        this.setInterval(2);
        return this;
    }

    public TestTask everyYear() {
        return this;
    }

    public TestTask occurs(int occurrences) {
        this.setOccurrence(occurrences);
        return this;
    }

    public TestTask relatedTo(TestTask originalTask) {
        return this.makeRelatedTo(originalTask);
    }

    public TestTask makeRelatedTo(TestTask originalTask) {
        this.setLastModified(originalTask.getLastModified());
        this.setObjectID(originalTask.getObjectID());
        this.setParentFolderID(originalTask.getParentFolderID());
        return this;
    }

    public TestTask clone() {
        TestTask newTask = new TestTask();
        for (int field : Task.ALL_COLUMNS) {
            Mapper mapper = Mapping.getMapping((int)field);
            if (mapper == null || !mapper.isSet((Task)this)) continue;
            mapper.set((Task)newTask, mapper.get((Task)this));
        }
        newTask.setTimezone(this.getTimezone());
        return newTask;
    }
}

