/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.importexport.formats.Format;
import com.openexchange.importexport.helpers.SizedInputStream;
import com.openexchange.java.Charsets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class SizedInputStreamTest {
    public byte[] testString = null;
    public SizedInputStream testStream = null;
    public static final String ENCODING = "UTF-8";
    public static final String TEXT = "Blabla";

    public static Test suite() {
        return new JUnit4TestAdapter(SizedInputStreamTest.class);
    }

    @Before
    public void setup() throws UnsupportedEncodingException {
        this.testString = TEXT.getBytes(ENCODING);
        this.testStream = new SizedInputStream((InputStream)new ByteArrayInputStream(this.testString), (long)this.testString.length, Format.CSV);
    }

    @After
    public void tearDown() throws IOException {
        this.testStream.close();
    }

    @org.junit.Test
    public void sizing() throws UnsupportedCharsetException {
        Assert.assertTrue((String)"First", (this.testStream.getSize() == (long)this.testString.length ? 1 : 0) != 0);
        Assert.assertTrue((String)"Second", (this.testStream.getSize() == (long)this.testString.length ? 1 : 0) != 0);
        Assert.assertTrue((String)"Third", (this.testStream.getSize() == (long)this.testString.length ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void normalReading() throws IOException {
        int l;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1];
        while ((l = this.testStream.read(buffer)) != -1) {
            baos.write(buffer, 0, l);
        }
        Assert.assertEquals((String)"Content", (Object)baos.toString(ENCODING), (Object)TEXT);
        baos.close();
        Assert.assertTrue((String)"", (this.testStream.getSize() == (long)this.testString.length ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void readingViaGetSize() throws IOException {
        byte[] buffer = new byte[(int)this.testStream.getSize()];
        this.testStream.read(buffer);
        String test2 = new String(buffer, Charsets.UTF_8);
        Assert.assertEquals((String)"Content comparison", (Object)test2, (Object)TEXT);
    }
}

