/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.RecurringResultInterface;
import com.openexchange.groupware.calendar.RecurringResultsInterface;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.container.CalendarObject;
import java.util.Date;

public class Bug12496Test
extends CalendarSqlTest {
    public void testChangeFulltimeRecAppToNonFulltime() throws Exception {
        try {
            CalendarDataObject fulltimeSeries = this.appointments.buildBasicAppointment(new Date(1225670400000L), new Date(1225756800000L));
            fulltimeSeries.setTitle("Fulltime-Recurring-Appointment");
            fulltimeSeries.setFullTime(true);
            fulltimeSeries.setRecurrenceType(1);
            fulltimeSeries.setInterval(1);
            fulltimeSeries.setOccurrence(5);
            this.appointments.save(fulltimeSeries);
            this.clean.add(fulltimeSeries);
            CalendarDataObject update = this.appointments.createIdentifyingCopy(fulltimeSeries);
            update.setFullTime(false);
            Date newStart = new Date(1225699200000L);
            update.setStartDate(newStart);
            Date newEnd = new Date(1225706400000L);
            update.setEndDate(newEnd);
            update.setRecurrenceType(1);
            update.setInterval(1);
            update.setOccurrence(5);
            this.appointments.save(update);
            CalendarDataObject firstOccurrence = this.appointments.reload(fulltimeSeries);
            firstOccurrence.calculateRecurrence();
            RecurringResultsInterface recuResults = this.getTools().calculateRecurring((CalendarObject)firstOccurrence, 0L, 0L, 1, 999, true);
            if (recuResults.size() == 0) {
                Bug12496Test.fail((String)"No occurrence at position 1");
            }
            RecurringResultInterface result = recuResults.getRecurringResult(0);
            firstOccurrence.setStartDate(new Date(result.getStart()));
            firstOccurrence.setEndDate(new Date(result.getEnd()));
            firstOccurrence.setRecurrencePosition(result.getPosition());
            Bug12496Test.assertEquals((String)"Unexpected start date: ", (Object)newStart, (Object)firstOccurrence.getStartDate());
            Bug12496Test.assertEquals((String)"Unexpected end date: ", (Object)newEnd, (Object)firstOccurrence.getEndDate());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

