/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.publish.tests;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.infostore.actions.InfostoreTestManager;
import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.datatypes.genericonf.FormElement;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.publish.Publication;
import com.openexchange.publish.PublicationTarget;
import com.openexchange.publish.SimPublicationTargetDiscoveryService;
import com.openexchange.subscribe.Subscription;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.test.ContactTestManager;
import com.openexchange.test.FolderTestManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.json.JSONException;
import org.xml.sax.SAXException;

public abstract class AbstractPubSubTest
extends AbstractAJAXSession {
    private FolderTestManager folderMgr;
    private ContactTestManager contactMgr;
    private InfostoreTestManager infostoreMgr;

    public AbstractPubSubTest(String name) {
        super(name);
    }

    public void setFolderManager(FolderTestManager folderMgr) {
        this.folderMgr = folderMgr;
    }

    public FolderTestManager getFolderManager() {
        return this.folderMgr;
    }

    public void setContactManager(ContactTestManager contactMgr) {
        this.contactMgr = contactMgr;
    }

    public ContactTestManager getContactManager() {
        return this.contactMgr;
    }

    public void setInfostoreManager(InfostoreTestManager infostoreMgr) {
        this.infostoreMgr = infostoreMgr;
    }

    public InfostoreTestManager getInfostoreManager() {
        return this.infostoreMgr;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setFolderManager(new FolderTestManager(this.getClient()));
        this.setContactManager(new ContactTestManager(this.getClient()));
        this.setInfostoreManager(new InfostoreTestManager(this.getClient()));
    }

    @Override
    protected void tearDown() throws Exception {
        this.getContactManager().cleanUp();
        this.getInfostoreManager().cleanUp();
        this.getFolderManager().cleanUp();
        super.tearDown();
    }

    protected Contact generateContact(String firstname, String lastname) {
        Contact contact = new Contact();
        contact.setGivenName(firstname);
        contact.setSurName(lastname);
        contact.setEmail1(firstname + "." + lastname + "@ox-test.invalid");
        contact.setDisplayName(firstname + " " + lastname);
        contact.setPosition("Testee");
        contact.setTitle("Tester");
        contact.setCompany("Testing-Company");
        return contact;
    }

    protected PublicationTarget generateMicroformatTarget(DynamicFormDescription form, String type) {
        PublicationTarget target = new PublicationTarget();
        target.setFormDescription(form);
        target.setId("com.openexchange.publish.microformats." + type + ".online");
        return target;
    }

    protected DynamicFormDescription generateOXMFFormDescription() {
        DynamicFormDescription form = new DynamicFormDescription();
        form.add(FormElement.input((String)"siteName", (String)"Site Name"));
        form.add(FormElement.checkbox((String)"protected", (String)"Protected"));
        form.add(FormElement.link((String)"url", (String)"URL"));
        return form;
    }

    protected Publication generatePublication(String type, String folder, SimPublicationTargetDiscoveryService discovery) {
        DynamicFormDescription form = this.generateOXMFFormDescription();
        PublicationTarget target = this.generateMicroformatTarget(form, type);
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("siteName", "publication-" + System.currentTimeMillis());
        config.put("protected", true);
        discovery.addTarget(target);
        Publication pub = new Publication();
        pub.setModule(type);
        pub.setEntityId(folder);
        pub.setTarget(target);
        pub.setConfiguration(config);
        return pub;
    }

    protected Publication generateInfostoreFolderPublication(String folder, SimPublicationTargetDiscoveryService discovery) {
        DynamicFormDescription form = this.generateOXMFFormDescription();
        PublicationTarget target = new PublicationTarget();
        target.setFormDescription(form);
        target.setId("com.openexchange.publish.online.infostore.document");
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("siteName", "publication");
        config.put("protected", true);
        discovery.addTarget(target);
        Publication pub = new Publication();
        pub.setModule("infostore/object");
        pub.setEntityId(folder);
        pub.setTarget(target);
        pub.setConfiguration(config);
        return pub;
    }

    protected Publication generateInfostoreItemPublication(String objId, SimPublicationTargetDiscoveryService discovery) {
        DynamicFormDescription form = this.generateOXMFFormDescription();
        PublicationTarget target = new PublicationTarget();
        target.setFormDescription(form);
        target.setId("com.openexchange.publish.online.infostore.document");
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("siteName", "publication");
        config.put("protected", true);
        discovery.addTarget(target);
        Publication pub = new Publication();
        pub.setModule("infostore/object");
        pub.setEntityId(objId);
        pub.setTarget(target);
        pub.setConfiguration(config);
        return pub;
    }

    protected Subscription generateOXMFSubscription(DynamicFormDescription formDescription, String folderID) throws OXException, IOException, SAXException, JSONException {
        Subscription sub = this.generateOXMFSubscription(formDescription);
        sub.setFolderId(folderID);
        return sub;
    }

    protected Subscription generateOXMFSubscription(DynamicFormDescription formDescription) throws OXException, IOException, SAXException, JSONException {
        Subscription subscription = new Subscription();
        subscription.setDisplayName("mySubscription");
        SubscriptionSource source = new SubscriptionSource();
        source.setId("com.openexchange.subscribe.microformats.contacts.http");
        source.setFormDescription(formDescription);
        subscription.setSource(source);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("url", "http://ox.open-xchange.com/1");
        subscription.setConfiguration(config);
        return subscription;
    }

    protected FolderObject createDefaultContactFolder() throws OXException, IOException, SAXException, JSONException {
        FolderObject folder = this.getFolderManager().generateFolder("pubsub default contact folder " + System.currentTimeMillis(), 3, this.getClient().getValues().getPrivateContactFolder(), this.getClient().getValues().getUserId());
        this.getFolderManager().insertFolderOnServer(folder);
        return folder;
    }

    protected FolderObject createDefaultInfostoreFolder() throws OXException, IOException, SAXException, JSONException {
        return this.createDefaultInfostoreFolder(null);
    }

    protected FolderObject createDefaultInfostoreFolder(String folderName) throws OXException, IOException, SAXException, JSONException {
        if (folderName == null) {
            folderName = "pubsub default infostore folder " + this.getName() + "-" + System.currentTimeMillis();
        }
        FolderObject folder = this.getFolderManager().generateFolder(folderName, 8, this.getClient().getValues().getPrivateInfostoreFolder(), this.getClient().getValues().getUserId());
        this.getFolderManager().insertFolderOnServer(folder);
        return folder;
    }

    protected Contact createDefaultContactFolderWithOneContact() throws OXException, IOException, SAXException, JSONException {
        FolderObject folder = this.createDefaultContactFolder();
        Contact contact = this.generateContact("Herbert", "Meier");
        contact.setParentFolderID(folder.getObjectID());
        this.getContactManager().newAction(contact);
        return contact;
    }

    private WebResponse getResponse(String url) throws IOException {
        WebConversation conv = new WebConversation();
        String correctedUrl = url;
        if (!correctedUrl.startsWith("http")) {
            correctedUrl = "http://" + url;
        }
        GetMethodWebRequest req = new GetMethodWebRequest(correctedUrl);
        return conv.getResource((WebRequest)req);
    }

    public String getWebsite(String url) throws IOException {
        WebResponse resp = this.getResponse(url);
        AbstractPubSubTest.assertEquals((String)"Should respond with status 200", (int)200, (int)resp.getResponseCode());
        return resp.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getDownload(String url) throws IOException {
        InputStream in = null;
        try {
            in = this.getResponse(url).getInputStream();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return in;
    }
}

