/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.ListRequest;
import org.json.JSONArray;

public class ListAliasTest
extends AbstractMailTest {
    private AJAXClient client;

    public ListAliasTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testListAlias() throws Exception {
        String[][] folderAndIds = this.getFolderAndIDs(this.client.getValues().getInboxFolder());
        ListRequest aliasRequest = new ListRequest(folderAndIds, "list");
        CommonListResponse aliasResponse = this.client.execute(aliasRequest);
        Object[][] aliasMails = aliasResponse.getArray();
        ListRequest request = new ListRequest(folderAndIds, new int[]{600, 601, 614, 602, 611, 603, 612, 607, 652, 610, 608, 102});
        CommonListResponse response = this.client.execute(request);
        Object[][] mails = response.getArray();
        ListAliasTest.assertEquals((String)"Arrays' sizes are not equal.", (int)aliasMails.length, (int)mails.length);
        for (int i = 0; i < aliasMails.length; ++i) {
            Object[] o1 = aliasMails[i];
            Object[] o2 = mails[i];
            ListAliasTest.assertEquals((String)"Objects' sizes are not equal.", (int)o1.length, (int)o2.length);
            for (int j = 0; j < o1.length; ++j) {
                if (o1[j] == null && o2[j] == null) continue;
                if (!(o1[j] instanceof JSONArray) && !(o2[j] instanceof JSONArray)) {
                    ListAliasTest.assertEquals((String)("Array[" + i + "][" + j + "] not equal."), (Object)o1[j], (Object)o2[j]);
                    continue;
                }
                this.compareArrays((JSONArray)o1[j], (JSONArray)o2[j]);
            }
        }
    }

    private void compareArrays(JSONArray o1, JSONArray o2) throws Exception {
        if (o1.length() != o2.length()) {
            ListAliasTest.fail((String)"Arrays' sizes are not equal.");
        }
        for (int i = 0; i < o1.length(); ++i) {
            if (o1.get(i) == null && o2.get(i) == null) continue;
            if (!(o1.get(i) instanceof JSONArray) && !(o2.get(i) instanceof JSONArray)) {
                ListAliasTest.assertEquals((String)("Array[" + i + "] not equal."), (String)o1.get(i).toString(), (String)o2.get(i).toString());
                continue;
            }
            this.compareArrays((JSONArray)o1.get(i), (JSONArray)o2.get(i));
        }
    }
}

