/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.AbstractAJAXTest;
import com.openexchange.ajax.MailTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.parser.ResponseParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.mail.MailListField;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class AlwaysTest
extends AbstractAJAXTest {
    private static final Log LOG = LogFactory.getLog(AlwaysTest.class);
    private static final Random rand = new Random(System.currentTimeMillis());
    private static final int MAX = -1;
    private static final int[] listAttributes = new int[]{MailListField.ID.getField(), MailListField.FOLDER_ID.getField(), MailListField.THREAD_LEVEL.getField(), MailListField.ATTACHMENT.getField(), MailListField.FROM.getField(), MailListField.SUBJECT.getField(), MailListField.RECEIVED_DATE.getField(), MailListField.SIZE.getField(), MailListField.FLAGS.getField(), MailListField.PRIORITY.getField(), 102};
    private AJAXClient client;

    public AlwaysTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.client = new AJAXClient(new AJAXSession(this.getWebConversation(), this.getHostName(), this.getSessionId()));
    }

    public void testFolderListing() throws Throwable {
        FolderObject imapRoot = this.getIMAPRootFolder();
        this.recListFolder(imapRoot.getFullName(), "");
    }

    public void recListFolder(String folderId, String rights) throws IOException, SAXException, JSONException, OXException, OXException {
        LOG.trace((Object)("Listing " + folderId));
        if (rights.length() > 0) {
            this.listMails(folderId, -1);
        }
        Map<String, String> subRights = AlwaysTest.getIMAPRights(this.client, folderId);
        for (Map.Entry<String, String> entry : subRights.entrySet()) {
            this.recListFolder(entry.getKey(), entry.getValue());
        }
    }

    private void listMails(String folderId, int max) throws IOException, SAXException, JSONException, OXException {
        JSONObject json = MailTest.getAllMails(this.getWebConversation(), this.getHostName(), this.getSessionId(), folderId, listAttributes, false);
        Response response = ResponseParser.parse((String)json.toString());
        AlwaysTest.assertFalse((String)response.getErrorMessage(), (boolean)response.hasError());
        JSONArray array = (JSONArray)response.getData();
        int count = max == -1 ? array.length() : Math.min(max, array.length());
        for (int i = 0; i < count; ++i) {
            int pos = max == -1 ? i : rand.nextInt(array.length());
            JSONArray mailInfo = array.getJSONArray(pos);
            String mailId = mailInfo.getString(0);
            LOG.info((Object)("Getting mail: " + mailId));
            Response mailResponse = MailTest.getMail(this.getWebConversation(), this.getHostName(), this.getSessionId(), mailId);
            AlwaysTest.assertFalse((String)mailResponse.getErrorMessage(), (boolean)mailResponse.hasError());
        }
    }

    public static Map<String, String> getIMAPRights(AJAXClient client, String parent) throws IOException, SAXException, JSONException, OXException {
        ListResponse listR = client.execute(new ListRequest((API)EnumAPI.OX_OLD, parent, new int[]{1, 305}, false));
        HashMap<String, String> retval = new HashMap<String, String>();
        for (Object[] row : listR) {
            retval.put(row[0].toString(), row[1].toString());
        }
        return retval;
    }

    public FolderObject getIMAPRootFolder() throws OXException, IOException, SAXException, JSONException, OXException {
        ListResponse listR = this.client.execute(new ListRequest((API)EnumAPI.OX_OLD, String.valueOf(1)));
        FolderObject defaultIMAPFolder = null;
        Iterator<FolderObject> iter = listR.getFolder();
        while (iter.hasNext()) {
            FolderObject fo = iter.next();
            if (!fo.containsFullName() || !fo.getFullName().equals("default")) continue;
            defaultIMAPFolder = fo;
            break;
        }
        AlwaysTest.assertTrue((String)"Can't find IMAP root folder.", (defaultIMAPFolder != null && defaultIMAPFolder.hasSubfolders() ? 1 : 0) != 0);
        return defaultIMAPFolder;
    }
}

