/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.importexport.AbstractVCardImportTest;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.java.Charsets;
import com.openexchange.webdav.xml.ContactTest;
import java.io.ByteArrayInputStream;

public class VCardImportLosingAddressInfoTest
extends AbstractVCardImportTest {
    public VCardImportLosingAddressInfoTest(String name) throws Exception {
        super(name);
    }

    public void test14350() throws Exception {
        String vcard = "BEGIN:VCARD\nVERSION:3.0\nPRODID:OPEN-XCHANGE\nFN:Prinz\\, Tobias\nN:Prinz;Tobias;;;\nNICKNAME:Tierlieb\nBDAY:19810501\nADR;TYPE=work:;;Broadway 3131 / 5th Ave;T\u221a\u00babingen;Baden-W\u221a\u00barttemberg;57621;Germany\nADR;TYPE=home:;;Testroad 4711;Port de la V\u221a\u00a9rde;Skol-upon-sea;37542;France\nORG:- deactivated -\nREV:20061204T160750.018Z\nUID:80@ox6.netline.de\nEND:VCARD\n";
        ImportResult[] importResult = VCardImportLosingAddressInfoTest.importVCard(this.getWebConversation(), new ByteArrayInputStream(vcard.getBytes(Charsets.UTF_8)), this.testFolder.getObjectID(), this.timeZone, this.emailaddress, this.getHostName(), this.getSessionId());
        VCardImportLosingAddressInfoTest.assertFalse((String)"Worked?", (boolean)importResult[0].hasError());
        int contactId = Integer.parseInt(importResult[0].getObjectId());
        Contact actual = ContactTest.loadContact(this.getWebConversation(), contactId, this.testFolder.getObjectID(), this.getHostName(), this.getLogin(), this.getPassword(), "");
        VCardImportLosingAddressInfoTest.assertEquals((String)"Checking name:", (String)"Prinz", (String)actual.getSurName());
        VCardImportLosingAddressInfoTest.assertEquals((String)"Street, business", (String)"Broadway 3131 / 5th Ave", (String)actual.getStreetBusiness());
        VCardImportLosingAddressInfoTest.assertEquals((String)"City, business", (String)"T\u221a\u00babingen", (String)actual.getCityBusiness());
        VCardImportLosingAddressInfoTest.assertEquals((String)"State, business", (String)"Baden-W\u221a\u00barttemberg", (String)actual.getStateBusiness());
        VCardImportLosingAddressInfoTest.assertEquals((String)"ZIP, business", (String)"57621", (String)actual.getPostalCodeBusiness());
        VCardImportLosingAddressInfoTest.assertEquals((String)"Country, business", (String)"Germany", (String)actual.getCountryBusiness());
        VCardImportLosingAddressInfoTest.assertEquals((String)"Street, home", (String)"Testroad 4711", (String)actual.getStreetHome());
        VCardImportLosingAddressInfoTest.assertEquals((String)"City, home", (String)"Port de la V\u221a\u00a9rde", (String)actual.getCityHome());
        VCardImportLosingAddressInfoTest.assertEquals((String)"State, home", (String)"Skol-upon-sea", (String)actual.getStateHome());
        VCardImportLosingAddressInfoTest.assertEquals((String)"ZIP, home", (String)"37542", (String)actual.getPostalCodeHome());
        VCardImportLosingAddressInfoTest.assertEquals((String)"Country, home", (String)"France", (String)actual.getCountryHome());
    }
}

