/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.importexport.ImportResult;
import org.json.JSONArray;
import org.json.JSONObject;

public class Bug6825Test_TruncationOfFields
extends ManagedAppointmentTest {
    public Bug6825Test_TruncationOfFields(String name) {
        super(name);
    }

    public void testUnexpectedException() throws Exception {
        String testMailAddress = "stephan.martin@open-xchange.com";
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:OPEN-XCHANGE\nBEGIN:VEVENT\nCLASS:PUBLIC\nCREATED:20060519T120300Z\nDTSTART:20060519T110000Z\nDTSTAMP:20070423T063205Z\nSUMMARY:External 1&1 Review call\nDTEND:20060519T120000Z\nATTENDEE:mailto:stephan.martin@open-xchange.com\nEND:VEVENT\nEND:VCALENDAR";
        ICalImportResponse importresponse = this.getClient().execute(new ICalImportRequest(this.folder.getObjectID(), "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:OPEN-XCHANGE\nBEGIN:VEVENT\nCLASS:PUBLIC\nCREATED:20060519T120300Z\nDTSTART:20060519T110000Z\nDTSTAMP:20070423T063205Z\nSUMMARY:External 1&1 Review call\nDTEND:20060519T120000Z\nATTENDEE:mailto:stephan.martin@open-xchange.com\nEND:VEVENT\nEND:VCALENDAR"));
        ImportResult imported = importresponse.getImports()[0];
        Appointment appointment = this.calendarManager.get(Integer.parseInt(imported.getFolder()), Integer.parseInt(imported.getObjectId()));
        Bug6825Test_TruncationOfFields.assertTrue((String)"Should have participants", (boolean)appointment.containsParticipants());
        Participant[] participants = appointment.getParticipants();
        Bug6825Test_TruncationOfFields.assertEquals((String)"Should have two participants", (int)2, (int)participants.length);
        Bug6825Test_TruncationOfFields.assertTrue((String)"One user is stephan.martin@open-xchange.com (external user)", ("stephan.martin@open-xchange.com".equals(participants[0].getEmailAddress()) || "stephan.martin@open-xchange.com".equals(participants[1].getEmailAddress()) ? 1 : 0) != 0);
        Bug6825Test_TruncationOfFields.assertTrue((String)"One user is the user doing the import", (participants[0].getIdentifier() == this.userId || participants[1].getIdentifier() == this.userId ? 1 : 0) != 0);
    }

    public void testTooMuchInformation() throws Exception {
        String testMailAddress = "stephan.martin@open-xchange.com";
        String stringTooLong = "zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... ";
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:OPEN-XCHANGE\nBEGIN:VEVENT\nCLASS:PUBLIC\nCREATED:20060519T120300Z\nDTSTART:20060519T110000Z\nDTSTAMP:20070423T063205Z\nSUMMARY:zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... \nDTEND:20060519T120000Z\nATTENDEE:mailto:stephan.martin@open-xchange.com\nEND:VEVENT\nEND:VCALENDAR";
        ICalImportResponse importresponse = this.getClient().execute(new ICalImportRequest(this.folder.getObjectID(), "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:OPEN-XCHANGE\nBEGIN:VEVENT\nCLASS:PUBLIC\nCREATED:20060519T120300Z\nDTSTART:20060519T110000Z\nDTSTAMP:20070423T063205Z\nSUMMARY:zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... \nDTEND:20060519T120000Z\nATTENDEE:mailto:stephan.martin@open-xchange.com\nEND:VEVENT\nEND:VCALENDAR", false));
        Bug6825Test_TruncationOfFields.assertTrue((boolean)importresponse.hasError());
        JSONObject data = ((JSONArray)importresponse.getData()).getJSONObject(0);
        Bug6825Test_TruncationOfFields.assertTrue((boolean)data.has("warnings"));
        JSONArray warnings = data.getJSONArray("warnings");
        Bug6825Test_TruncationOfFields.assertEquals((int)1, (int)warnings.length());
        Bug6825Test_TruncationOfFields.assertTrue((boolean)warnings.getJSONObject(0).toString().contains("truncated"));
    }
}

