/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.framework;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.java.Autoboxing;
import org.json.JSONArray;
import org.json.JSONException;

public abstract class AbstractColumnsParser<T extends AbstractColumnsResponse>
extends AbstractAJAXParser<T> {
    private final int[] columns;

    protected AbstractColumnsParser(boolean failOnError, int[] columns) {
        super(failOnError);
        this.columns = columns;
    }

    @Override
    protected T createResponse(Response response) throws JSONException {
        T retval = this.instantiateResponse(response);
        ((AbstractColumnsResponse)retval).setColumns(this.columns);
        JSONArray array = (JSONArray)((AbstractAJAXResponse)((Object)retval)).getData();
        if (this.isFailOnError() || null != array) {
            ((AbstractColumnsResponse)retval).setArray(AbstractColumnsParser.parseData(array));
        }
        return retval;
    }

    private static Object[][] parseData(JSONArray array) throws JSONException {
        Object[][] values = new Object[array.length()][];
        for (int i = 0; i < array.length(); ++i) {
            try {
                JSONArray inner = array.getJSONArray(i);
                values[i] = new Object[inner.length()];
                for (int j = 0; j < inner.length(); ++j) {
                    values[i][j] = inner.isNull(j) ? null : inner.get(j);
                }
                continue;
            }
            catch (JSONException e) {
                values[i] = new Integer[]{Autoboxing.I((int)array.getInt(i))};
            }
        }
        return values;
    }

    protected abstract T instantiateResponse(Response var1);

    protected int[] getColumns() {
        return this.columns;
    }
}

