/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.api2;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.VisibleFoldersRequest;
import com.openexchange.ajax.folder.actions.VisibleFoldersResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Autoboxing;
import com.openexchange.test.PermissionTools;
import java.util.Iterator;

public class VisibleFoldersTest
extends AbstractAJAXSession {
    private AJAXClient clientA;
    private AJAXClient clientB;
    private FolderObject createdPrivateFolder;
    private FolderObject createdPublicFolder;
    private FolderObject createdSharedFolder;

    public VisibleFoldersTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.clientA = this.getClient();
        this.clientB = new AJAXClient(AJAXClient.User.User2);
        this.createdPrivateFolder = new FolderObject();
        this.createdPrivateFolder.setModule(2);
        this.createdPrivateFolder.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.createdPrivateFolder.setType(1);
        this.createdPrivateFolder.setPermissions(PermissionTools.P(Autoboxing.I((int)this.clientA.getValues().getUserId()), "arawada/a"));
        this.createdPrivateFolder.setFolderName("testPrivateCalendarFolder" + System.currentTimeMillis());
        InsertRequest iReq = new InsertRequest(EnumAPI.OUTLOOK, this.createdPrivateFolder);
        InsertResponse iResp = this.client.execute(iReq);
        iResp.fillObject((DataObject)this.createdPrivateFolder);
        this.createdPublicFolder = new FolderObject();
        this.createdPublicFolder.setModule(2);
        this.createdPublicFolder.setParentFolderID(2);
        this.createdPublicFolder.setType(2);
        this.createdPublicFolder.setPermissions(PermissionTools.P(Autoboxing.I((int)this.clientA.getValues().getUserId()), "arawada/a"));
        this.createdPublicFolder.setFolderName("testPublicCalendarFolder" + System.currentTimeMillis());
        iReq = new InsertRequest(EnumAPI.OUTLOOK, this.createdPublicFolder);
        iResp = this.client.execute(iReq);
        iResp.fillObject((DataObject)this.createdPublicFolder);
        this.createdSharedFolder = new FolderObject();
        this.createdSharedFolder.setModule(2);
        this.createdSharedFolder.setParentFolderID(this.clientB.getValues().getPrivateAppointmentFolder());
        this.createdSharedFolder.setType(1);
        this.createdSharedFolder.setPermissions(PermissionTools.P(Autoboxing.I((int)this.clientB.getValues().getUserId()), "arawada/a", Autoboxing.I((int)this.clientA.getValues().getUserId()), "arawada"));
        this.createdSharedFolder.setFolderName("testSharedCalendarFolder" + System.currentTimeMillis());
        iReq = new InsertRequest(EnumAPI.OUTLOOK, this.createdSharedFolder);
        iResp = this.clientB.execute(iReq);
        iResp.fillObject((DataObject)this.createdSharedFolder);
    }

    @Override
    protected void tearDown() throws Exception {
        this.clientA.execute(new DeleteRequest((API)EnumAPI.OUTLOOK, this.createdPrivateFolder));
        this.clientA.execute(new DeleteRequest((API)EnumAPI.OUTLOOK, this.createdPublicFolder));
        this.clientB.execute(new DeleteRequest((API)EnumAPI.OUTLOOK, this.createdSharedFolder));
        super.tearDown();
    }

    public void testForVisibleFolders() throws Throwable {
        VisibleFoldersRequest req = new VisibleFoldersRequest(EnumAPI.OUTLOOK, "calendar");
        VisibleFoldersResponse resp = this.client.execute(req);
        Iterator<FolderObject> privIter = resp.getPrivateFolders();
        boolean found = false;
        while (privIter.hasNext()) {
            FolderObject privateFolder = privIter.next();
            if (privateFolder.getObjectID() != this.createdPrivateFolder.getObjectID()) continue;
            found = true;
            break;
        }
        VisibleFoldersTest.assertTrue((String)"Previously created private folder not found in private folders.", (boolean)found);
        Iterator<FolderObject> pubIter = resp.getPublicFolders();
        found = false;
        while (pubIter.hasNext()) {
            FolderObject publicFolder = pubIter.next();
            if (publicFolder.getObjectID() != this.createdPublicFolder.getObjectID()) continue;
            found = true;
            break;
        }
        VisibleFoldersTest.assertTrue((String)"Previously created public folder not found in public folders.", (boolean)found);
        Iterator<FolderObject> sharedIter = resp.getSharedFolders();
        found = false;
        while (sharedIter.hasNext()) {
            FolderObject sharedFolder = sharedIter.next();
            if (sharedFolder.getObjectID() != this.createdSharedFolder.getObjectID()) continue;
            found = true;
            break;
        }
        VisibleFoldersTest.assertTrue((String)"Previously created shared folder not found in shared folders.", (boolean)found);
    }

    public void testFindingGlobalAddressbook() throws Exception {
        VisibleFoldersRequest req = new VisibleFoldersRequest(EnumAPI.OUTLOOK, "contacts");
        VisibleFoldersResponse resp = this.client.execute(req);
        Iterator<FolderObject> publicFolders = resp.getPublicFolders();
        boolean globalAddressBookFound = false;
        while (publicFolders.hasNext()) {
            if (publicFolders.next().getObjectID() != 6) continue;
            globalAddressBookFound = true;
        }
        VisibleFoldersTest.assertTrue((String)"Could not find the global address book", (boolean)globalAddressBookFound);
    }
}

