/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact.action;

import com.openexchange.ajax.contact.action.AbstractContactRequest;
import com.openexchange.ajax.contact.action.SearchParser;
import com.openexchange.ajax.contact.action.SearchResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Params;
import com.openexchange.java.Strings;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class AdvancedSearchRequest
extends AbstractContactRequest<SearchResponse> {
    private JSONObject filter;
    private int orderBy;
    private String orderDir;
    private int[] columns;
    private String collation;

    public void setFilter(JSONObject filter) {
        this.filter = filter;
    }

    public void setOrderBy(int orderBy) {
        this.orderBy = orderBy;
    }

    public void setOrderDir(String orderDir) {
        this.orderDir = orderDir;
    }

    public void setColumns(int[] columns) {
        this.columns = columns;
    }

    public void setCollation(String collation) {
        this.collation = collation;
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        return this.filter;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        Params params = new Params("action", "advancedSearch");
        if (this.columns != null) {
            params.add("columns", Strings.join((int[])this.columns, (String)","));
        }
        if (this.orderBy != -1) {
            params.add("sort", String.valueOf(this.orderBy));
        }
        if (this.orderDir != null) {
            params.add("order", this.orderDir);
        }
        if (this.collation != null) {
            params.add("collation", this.collation);
        }
        return params.toArray();
    }

    @Override
    public AbstractAJAXParser<SearchResponse> getParser() {
        return new SearchParser(true, this.columns);
    }

    public AdvancedSearchRequest() {
    }

    public AdvancedSearchRequest(JSONObject filter, int[] columns, int orderBy, String orderDir) {
        this();
        this.setFilter(filter);
        this.setColumns(columns);
        this.setOrderBy(orderBy);
        this.setOrderDir(orderDir);
    }

    public AdvancedSearchRequest(JSONObject filter, int[] columns, int orderBy, String orderDir, String collation) {
        this(filter, columns, orderBy, orderDir);
        this.setCollation(collation);
    }
}

