/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.modules.Module;
import com.openexchange.test.ContactTestManager;
import com.openexchange.test.FolderTestManager;
import java.util.Date;

public abstract class AbstractManagedContactTest
extends AbstractAJAXSession {
    protected ContactTestManager manager;
    protected FolderTestManager folderManager;
    protected int folderID;

    public AbstractManagedContactTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager = new ContactTestManager(this.getClient());
        this.manager.setFailOnError(false);
        this.folderManager = new FolderTestManager(this.getClient());
        this.folderManager.setFailOnError(false);
        UserValues values = this.getClient().getValues();
        FolderObject folder = this.folderManager.generateFolder("ManagedContactTest_" + new Date().getTime(), Module.CONTACTS.getFolderConstant(), values.getPrivateContactFolder(), values.getUserId());
        folder = this.folderManager.insertFolderOnServer(folder);
        this.folderID = folder.getObjectID();
    }

    @Override
    public void tearDown() throws Exception {
        this.manager.cleanUp();
        this.folderManager.cleanUp();
        super.tearDown();
    }

    protected Contact generateContact(String lastname) {
        Contact contact = new Contact();
        contact.setSurName(lastname);
        contact.setGivenName("Given name");
        contact.setDisplayName(contact.getSurName() + ", " + contact.getGivenName());
        contact.setParentFolderID(this.folderID);
        return contact;
    }

    protected Contact generateContact() {
        return this.generateContact("Surname");
    }
}

