/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class Bug12264Test
extends AbstractAJAXSession {
    private AJAXClient client = null;
    private int objectId = 0;
    private int folderId = 0;
    private Date lastModified = null;
    private TimeZone tz = null;
    private Appointment appointment = null;

    public Bug12264Test(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetUntilToNullWithExistingOccurrences() throws Throwable {
        this.prepareWithOccurrences("bug 12264 test - set until to null with existing occurrences");
        try {
            this.insertAppointment();
            this.appointment.removeOccurrence();
            UntilNullAppointmentUpdateRequest updateRequest = new UntilNullAppointmentUpdateRequest(this.appointment, this.tz);
            UpdateResponse updateResponse = this.client.execute(updateRequest);
            this.appointment.setLastModified(updateResponse.getTimestamp());
            this.lastModified = this.appointment.getLastModified();
            this.getAppointment();
            this.checkForNoEnd();
        }
        finally {
            this.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetUntilToNullWithExistingUntil() throws Throwable {
        this.prepareWithUntil("bug 12264 test - set until to null with existing until");
        try {
            this.insertAppointment();
            this.appointment.removeOccurrence();
            UntilNullAppointmentUpdateRequest updateRequest = new UntilNullAppointmentUpdateRequest(this.appointment, this.tz);
            UpdateResponse updateResponse = this.client.execute(updateRequest);
            this.appointment.setLastModified(updateResponse.getTimestamp());
            this.lastModified = this.appointment.getLastModified();
            this.getAppointment();
            this.checkForNoEnd();
        }
        finally {
            this.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetOccurrencesTo0WithExistingOccurrences() throws Throwable {
        this.prepareWithOccurrences("bug 12264 test - set occurrences to 0 with existing occurrences");
        try {
            this.insertAppointment();
            this.appointment.setOccurrence(0);
            this.updateAppointment(true);
            this.getAppointment();
            this.checkForNoEnd();
        }
        finally {
            this.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetOccurrencesTo0WithExistingUntil() throws Throwable {
        this.prepareWithUntil("bug 12264 test - set occurrences to 0 with existing until");
        try {
            this.insertAppointment();
            this.appointment.setOccurrence(0);
            this.appointment.removeUntil();
            this.updateAppointment(true);
            this.getAppointment();
            this.checkForNoEnd();
        }
        finally {
            this.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetOccurrencesToNullWithExistingOccurrences() throws Throwable {
        this.prepareWithOccurrences("bug 12264 test - set occurrences to null with existing occurrences");
        try {
            this.insertAppointment();
            this.appointment.removeOccurrence();
            OccurrencesNullAppointmentUpdateRequest updateRequest = new OccurrencesNullAppointmentUpdateRequest(this.appointment, this.tz);
            UpdateResponse updateResponse = this.client.execute(updateRequest);
            this.appointment.setLastModified(updateResponse.getTimestamp());
            this.lastModified = this.appointment.getLastModified();
            this.getAppointment();
            this.checkForNoEnd();
        }
        finally {
            this.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetOccurrencesToNullWithExistingUntil() throws Throwable {
        this.prepareWithUntil("bug 12264 test - set occurrences to null with existing until");
        try {
            this.insertAppointment();
            this.appointment.removeOccurrence();
            this.appointment.removeUntil();
            OccurrencesNullAppointmentUpdateRequest updateRequest = new OccurrencesNullAppointmentUpdateRequest(this.appointment, this.tz);
            UpdateResponse updateResponse = this.client.execute(updateRequest);
            this.appointment.setLastModified(updateResponse.getTimestamp());
            this.lastModified = this.appointment.getLastModified();
            this.getAppointment();
            this.checkForNoEnd();
        }
        finally {
            this.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBugAsWritten() throws Throwable {
        this.prepareWithOccurrences("bug 12264 test - as written");
        try {
            this.appointment.removeRecurrenceType();
            this.appointment.removeDays();
            this.appointment.removeInterval();
            this.appointment.removeOccurrence();
            this.insertAppointment();
            this.appointment.setRecurrenceType(2);
            this.appointment.setDays(8);
            this.appointment.setInterval(1);
            this.appointment.setOccurrence(2);
            this.updateAppointment(true);
            this.getAppointment();
            Bug12264Test.assertEquals((String)"Unexpected occurrence value", (int)2, (int)this.appointment.getOccurrence());
            this.appointment.removeOccurrence();
            this.appointment.setIgnoreConflicts(true);
            UntilNullAppointmentUpdateRequest updateRequest = new UntilNullAppointmentUpdateRequest(this.appointment, this.tz);
            UpdateResponse updateResponse = this.client.execute(updateRequest);
            this.appointment.setLastModified(updateResponse.getTimestamp());
            this.lastModified = this.appointment.getLastModified();
            this.getAppointment();
            this.checkForNoEnd();
        }
        finally {
            this.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBugAsWrittenAccordingComment11() throws Throwable {
        this.prepareWithOccurrences("bug 12264 test - as written, comment 11");
        try {
            this.insertAppointment();
            int tempOccurrence = this.appointment.getOccurrence();
            this.appointment.removeOccurrence();
            this.appointment.setUntil(new Date(0L));
            UpdateResponse response = this.updateAppointment(false);
            Bug12264Test.assertTrue((boolean)response.hasError());
            OXException exception = response.getException();
            Bug12264Test.assertTrue((String)"Wrong exception thrown.", (boolean)exception.similarTo((OXExceptionCode)OXCalendarExceptionCodes.UNTIL_BEFORE_START_DATE));
            Bug12264Test.assertFalse((String)"No occurrence left.", (tempOccurrence == 0 ? 1 : 0) != 0);
        }
        finally {
            this.cleanUp();
        }
    }

    private void checkForNoEnd() throws Throwable {
        if (this.appointment.containsUntil()) {
            Bug12264Test.assertNull((String)("Until exists and is not null. Until: " + this.appointment.getUntil()), (Object)this.appointment.getUntil());
        }
        if (this.appointment.containsOccurrence()) {
            Bug12264Test.assertEquals((String)("Occurrences exist and is not 0. Occurrences: " + this.appointment.getOccurrence()), (int)0, (int)this.appointment.getOccurrence());
        }
    }

    private void insertAppointment() throws Throwable {
        InsertRequest request = new InsertRequest(this.appointment, this.tz);
        CommonInsertResponse response = this.client.execute(request);
        this.appointment.setObjectID(response.getId());
        this.appointment.setLastModified(response.getTimestamp());
        this.objectId = this.appointment.getObjectID();
        this.lastModified = this.appointment.getLastModified();
    }

    private UpdateResponse updateAppointment(boolean failOnError) throws Throwable {
        UpdateRequest updateRequest = new UpdateRequest(this.appointment, this.tz, failOnError);
        UpdateResponse updateResponse = this.client.execute(updateRequest);
        if (updateResponse.getTimestamp() != null) {
            this.appointment.setLastModified(updateResponse.getTimestamp());
        }
        this.lastModified = this.appointment.getLastModified();
        return updateResponse;
    }

    private void getAppointment() throws Throwable {
        GetRequest getRequest = new GetRequest(this.folderId, this.appointment.getObjectID());
        GetResponse getResponse = this.client.execute(getRequest);
        this.appointment = getResponse.getAppointment(this.tz);
    }

    private void prepareWithOccurrences(String title) throws Throwable {
        this.client = this.getClient();
        this.tz = this.client.getValues().getTimeZone();
        this.folderId = this.client.getValues().getPrivateAppointmentFolder();
        this.appointment = new Appointment();
        this.appointment.setTitle(title);
        this.appointment.setParentFolderID(this.folderId);
        this.appointment.setIgnoreConflicts(true);
        Calendar calendar = TimeTools.createCalendar(this.tz);
        calendar.set(11, 8);
        this.appointment.setStartDate(calendar.getTime());
        calendar.set(11, 9);
        this.appointment.setEndDate(calendar.getTime());
        this.appointment.setRecurrenceType(2);
        this.appointment.setDays(8);
        this.appointment.setInterval(1);
        this.appointment.setOccurrence(2);
    }

    private void prepareWithUntil(String title) throws Throwable {
        this.client = this.getClient();
        this.tz = this.client.getValues().getTimeZone();
        this.folderId = this.client.getValues().getPrivateAppointmentFolder();
        this.appointment = new Appointment();
        this.appointment.setTitle(title);
        this.appointment.setParentFolderID(this.folderId);
        this.appointment.setIgnoreConflicts(true);
        Calendar calendar = TimeTools.createCalendar(this.tz);
        calendar.set(11, 8);
        this.appointment.setStartDate(calendar.getTime());
        calendar.set(11, 9);
        this.appointment.setEndDate(calendar.getTime());
        this.appointment.setRecurrenceType(2);
        this.appointment.setDays(8);
        this.appointment.setInterval(1);
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(6, 21);
        this.appointment.setUntil(calendar.getTime());
    }

    private void cleanUp() throws Throwable {
        if (this.objectId != 0 && this.folderId != 0 && this.lastModified != null && this.client != null) {
            DeleteRequest deleteRequest = new DeleteRequest(this.objectId, this.folderId, this.lastModified);
            this.client.execute(deleteRequest);
        }
        this.client = null;
        this.objectId = 0;
        this.folderId = 0;
        this.lastModified = null;
        this.tz = null;
        this.appointment = null;
    }

    private class OccurrencesNullAppointmentUpdateRequest
    extends UpdateRequest {
        public OccurrencesNullAppointmentUpdateRequest(Appointment appointmentObj, TimeZone timeZone) {
            super(appointmentObj, timeZone);
        }

        @Override
        public JSONObject getBody() throws JSONException {
            JSONObject json = super.getBody();
            json.put("occurrences", JSONObject.NULL);
            return json;
        }
    }

    private class UntilNullAppointmentUpdateRequest
    extends UpdateRequest {
        public UntilNullAppointmentUpdateRequest(Appointment appointmentObj, TimeZone timeZone) {
            super(appointmentObj, timeZone);
        }

        @Override
        public JSONObject getBody() throws JSONException {
            JSONObject json = super.getBody();
            json.put("until", JSONObject.NULL);
            return json;
        }
    }
}

