/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.actions;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.json.filter.DoNothingUserCensorship;
import com.openexchange.user.json.filter.NoGlobalAdressBookUserCensorship;
import com.openexchange.user.json.filter.UserCensorship;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class AbstractUserAction
implements AJAXActionService {
    private static final String ALL = "*";
    private static final Pattern SPLIT = Pattern.compile(" *, *");
    private static final Pattern PAT = Pattern.compile(" *, *");
    private static final UserCensorship DO_NOTHING_USER_CENSORSHIP = new DoNothingUserCensorship();
    private static final UserCensorship NO_GLOBAL_ADDRESSBOOK_USER_CENSORSHIP = new NoGlobalAdressBookUserCensorship();

    protected AbstractUserAction() {
    }

    protected static Map<String, List<String>> getAttributeParameters(Set<String> expectedParameterNames, AJAXRequestData request) throws OXException {
        Iterator nonMatchingParameters = request.getNonMatchingParameters(expectedParameterNames);
        if (!nonMatchingParameters.hasNext()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<String>> attributeParameters = new LinkedHashMap<String, List<String>>();
        do {
            String value;
            int pos;
            Map.Entry entry;
            String key;
            ArrayList<String> list;
            if (null == (list = (ArrayList<String>)attributeParameters.get(key = (String)(entry = (Map.Entry)nonMatchingParameters.next()).getKey()))) {
                list = new ArrayList<String>(4);
                attributeParameters.put(key, list);
            }
            if ((pos = (value = (String)entry.getValue()).indexOf(42)) < 0) {
                String[] strings;
                for (String string : strings = SPLIT.split(value, 0)) {
                    list.add(string);
                }
            } else {
                if (value.length() > 1) {
                    throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(new Object[]{key, value});
                }
                list.add(ALL);
            }
        } while (nonMatchingParameters.hasNext());
        return attributeParameters;
    }

    protected static Long parseLongParameter(String parameterName, AJAXRequestData request) throws OXException {
        String tmp = request.getParameter(parameterName);
        if (null == tmp) {
            return null;
        }
        tmp = tmp.trim();
        try {
            return Long.valueOf(tmp);
        }
        catch (NumberFormatException e) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(new Object[]{parameterName, tmp});
        }
    }

    protected static long checkLongParameter(String parameterName, AJAXRequestData request) throws OXException {
        String tmp = request.getParameter(parameterName);
        if (null == tmp) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(new Object[]{parameterName});
        }
        tmp = tmp.trim();
        try {
            return Long.parseLong(tmp);
        }
        catch (NumberFormatException e) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(new Object[]{parameterName, tmp});
        }
    }

    protected static int parseIntParameter(String parameterName, AJAXRequestData request) throws OXException {
        String tmp = request.getParameter(parameterName);
        if (null == tmp) {
            return -1;
        }
        tmp = tmp.trim();
        try {
            return Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(new Object[]{parameterName, tmp});
        }
    }

    protected static int checkIntParameter(String parameterName, AJAXRequestData request) throws OXException {
        String tmp = request.getParameter(parameterName);
        if (null == tmp) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(new Object[]{parameterName});
        }
        tmp = tmp.trim();
        try {
            return Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(new Object[]{parameterName, tmp});
        }
    }

    protected static String checkStringParameter(String parameterName, AJAXRequestData request) throws OXException {
        String tmp = request.getParameter(parameterName);
        if (null == tmp) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(new Object[]{parameterName});
        }
        return tmp.trim();
    }

    protected static int[] parseIntArrayParameter(String parameterName, AJAXRequestData request) throws OXException {
        String tmp = request.getParameter(parameterName);
        if (null == tmp) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(new Object[]{parameterName});
        }
        String[] sa = PAT.split(tmp, 0);
        int[] columns = new int[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            columns[i] = Integer.parseInt(sa[i]);
        }
        return columns;
    }

    protected static int[] parseOptionalIntArrayParameter(String parameterName, AJAXRequestData request) {
        String tmp = request.getParameter(parameterName);
        if (null == tmp) {
            return new int[0];
        }
        String[] sa = PAT.split(tmp, 0);
        int[] columns = new int[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            columns[i] = Integer.parseInt(sa[i]);
        }
        return columns;
    }

    protected static void censor(ServerSession session, User[] user) throws OXException {
        UserCensorship censorship = AbstractUserAction.getUserCensorship(session);
        for (int i = 0; i < user.length; ++i) {
            if (user[i].getId() == session.getUserId()) continue;
            user[i] = censorship.censor(user[i]);
        }
    }

    protected static User censor(ServerSession session, User user) throws OXException {
        if (user.getId() == session.getUserId()) {
            return user;
        }
        UserCensorship censorship = AbstractUserAction.getUserCensorship(session);
        return censorship.censor(user);
    }

    protected static UserCensorship getUserCensorship(ServerSession session) throws OXException {
        if (AbstractUserAction.canSeeGlobalAddressBook(session)) {
            return DO_NOTHING_USER_CENSORSHIP;
        }
        return NO_GLOBAL_ADDRESSBOOK_USER_CENSORSHIP;
    }

    private static boolean canSeeGlobalAddressBook(ServerSession session) throws OXException {
        OXFolderAccess folderAccess = new OXFolderAccess(session.getContext());
        EffectivePermission folderPermission = folderAccess.getFolderPermission(6, session.getUserId(), session.getUserConfiguration());
        return folderPermission.canReadAllObjects() && folderPermission.isFolderVisible();
    }
}

