/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp.config;

import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.mime.MimeDefaultSession;
import java.util.Map;
import java.util.Properties;

public final class SMTPSessionProperties {
    private static volatile Properties sessionProperties;

    private SMTPSessionProperties() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties getDefaultSessionProperties() {
        Properties tmp = sessionProperties;
        if (null != tmp) return (Properties)tmp.clone();
        Class<SMTPSessionProperties> clazz = SMTPSessionProperties.class;
        synchronized (SMTPSessionProperties.class) {
            tmp = sessionProperties;
            if (null != tmp) return (Properties)tmp.clone();
            SMTPSessionProperties.initializeSMTPProperties();
            tmp = sessionProperties;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (Properties)tmp.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void resetDefaultSessionProperties() {
        if (null == sessionProperties) return;
        Class<SMTPSessionProperties> clazz = SMTPSessionProperties.class;
        synchronized (SMTPSessionProperties.class) {
            if (null == sessionProperties) return;
            sessionProperties = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void initializeSMTPProperties() {
        sessionProperties = MimeDefaultSession.getDefaultMailProperties();
        Properties properties = sessionProperties;
        if (!properties.containsKey("mail.mime.base64.ignoreerrors")) {
            properties.put("mail.mime.base64.ignoreerrors", "true");
            System.getProperties().put("mail.mime.base64.ignoreerrors", "true");
        }
        if (!properties.containsKey("mail.imap.allowreadonlyselect")) {
            properties.put("mail.imap.allowreadonlyselect", "true");
            System.getProperties().put("mail.imap.allowreadonlyselect", "true");
        }
        if (!properties.containsKey("mail.mime.encodeeol.strict")) {
            properties.put("mail.mime.encodeeol.strict", "true");
            System.getProperties().put("mail.mime.encodeeol.strict", "true");
        }
        if (!properties.containsKey("mail.mime.decodetext.strict")) {
            properties.put("mail.mime.decodetext.strict", "false");
            System.getProperties().put("mail.mime.decodetext.strict", "false");
        }
        if (!properties.containsKey("mail.mime.charset")) {
            properties.put("mail.mime.charset", MailProperties.getInstance().getDefaultMimeCharset());
            System.getProperties().put("mail.mime.charset", MailProperties.getInstance().getDefaultMimeCharset());
        }
        properties.put("mail.smtp.auth.ntlm.disable", "true");
        if (MailProperties.getInstance().getJavaMailProperties() != null) {
            properties.putAll((Map<?, ?>)MailProperties.getInstance().getJavaMailProperties());
        }
    }
}

