/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.results;

import java.util.ArrayList;
import java.util.List;

public class CollectionDelta<T> {
    private final List<T> newAndModified = new ArrayList<T>();
    private final List<T> deleted = new ArrayList<T>();

    public void addNewOrModified(T thing) {
        this.newAndModified.add(thing);
    }

    public void addDeleted(T thing) {
        this.deleted.add(thing);
    }

    public List<T> getNewAndModified() {
        return this.newAndModified;
    }

    public List<T> getDeleted() {
        return this.deleted;
    }

    public void visitAll(DeltaVisitor<T> visitor) {
        for (T thing : this.newAndModified) {
            visitor.newOrModified(thing);
        }
        for (T thing : this.deleted) {
            visitor.deleted(thing);
        }
    }

    public static interface DeltaVisitor<T> {
        public void newOrModified(T var1);

        public void deleted(T var1);
    }
}

