/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.common.osgi;

import java.util.Arrays;
import java.util.HashSet;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public final class CommonActivator
implements BundleActivator {
    public void start(BundleContext context) throws Exception {
        Log logger = LogFactory.getLog(CommonActivator.class);
        logger.info((Object)"Starting bundle: com.openexchange.common");
        try {
            this.initializeMailCap();
        }
        catch (Exception e) {
            logger.info((Object)("Starting bundle 'com.openexchange.common' failed: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    public void stop(BundleContext context) throws Exception {
        Log logger = LogFactory.getLog(CommonActivator.class);
        logger.info((Object)"Stopping bundle: com.openexchange.common");
    }

    private void initializeMailCap() {
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        HashSet<String> types = new HashSet<String>(Arrays.asList(mc.getMimeTypes()));
        boolean apply = false;
        if (!types.contains("text/html")) {
            mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
            apply = true;
        }
        if (!types.contains("text/xml")) {
            mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
            apply = true;
        }
        if (!types.contains("text/plain")) {
            mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
            apply = true;
        }
        if (!types.contains("multipart/*")) {
            mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed; x-java-fallback-entry=true");
            apply = true;
        }
        if (!types.contains("message/rfc822")) {
            mc.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
            apply = true;
        }
        if (apply) {
            CommandMap.setDefaultCommandMap((CommandMap)mc);
        }
    }
}

