/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.contact;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.webdav.xml.ContactTest;
import java.util.Date;
import java.util.Locale;

public class ListTest
extends ContactTest {
    public ListTest(String name) {
        super(name);
    }

    public void testPropFindWithModified() throws Exception {
        Contact contactObj = this.createContactObject("testPropFindWithModified");
        int objectId1 = ListTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        int objectId2 = ListTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        Thread.sleep(1000L);
        Contact loadContact = ListTest.loadContact(this.getWebConversation(), objectId1, this.contactFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Date modified = loadContact.getLastModified();
        Contact[] contactArray = ListTest.listContact(this.webCon, this.contactFolderId, ListTest.decrementDate(modified), true, false, "http://" + this.hostName, this.login, this.password, this.context);
        ListTest.assertTrue((String)"check response", (contactArray.length >= 2 ? 1 : 0) != 0);
        ListTest.deleteContact(this.getWebConversation(), objectId1, this.contactFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        ListTest.deleteContact(this.getWebConversation(), objectId2, this.contactFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testPropFindWithDelete() throws Exception {
        Contact contactObj = this.createContactObject("testPropFindWithModified");
        int objectId1 = ListTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        int objectId2 = ListTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        int[][] objectIdAndFolderId = new int[][]{{objectId1, this.contactFolderId}, {objectId2, this.contactFolderId}};
        Contact loadContact = ListTest.loadContact(this.getWebConversation(), objectId1, this.contactFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Date modified = loadContact.getLastModified();
        ListTest.deleteContact(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
        Thread.sleep(1000L);
        Contact[] appointmentArray = ListTest.listContact(this.webCon, this.contactFolderId, ListTest.decrementDate(modified), false, true, "http://" + this.hostName, this.login, this.password, this.context);
        ListTest.assertTrue((String)"wrong response array length", (appointmentArray.length >= 2 ? 1 : 0) != 0);
    }

    public void testPropFindWithObjectId() throws Exception {
        Contact contactObj = this.createContactObject("testPropFindWithObjectId");
        int objectId = ListTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        Contact loadContact = ListTest.loadContact(this.webCon, objectId, this.contactFolderId, "http://" + this.hostName, this.login, this.password, this.context);
        contactObj.setObjectID(objectId);
        ListTest.compareObject(contactObj, loadContact);
        ListTest.deleteContact(this.getWebConversation(), objectId, this.contactFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testObjectNotFound() throws Exception {
        Contact contactObj = this.createContactObject("testObjectNotFound");
        int objectId = ListTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        try {
            ListTest.loadContact(this.webCon, objectId + 1000, this.contactFolderId, "http://" + this.hostName, this.login, this.password, this.context);
            ListTest.fail((String)"object not found exception expected!");
        }
        catch (OXException exc) {
            ListTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), 1001);
        }
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.contactFolderId}};
        ListTest.deleteContact(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testListWithAllFields() throws Exception {
        Contact contactObj = this.createCompleteContactObject();
        int objectId = ListTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        Thread.sleep(1000L);
        Contact loadContact = ListTest.loadContact(this.getWebConversation(), objectId, this.contactFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Date modified = loadContact.getLastModified();
        Contact[] appointmentArray = ListTest.listContact(this.webCon, this.contactFolderId, ListTest.decrementDate(modified), true, false, "http://" + this.hostName, this.login, this.password, this.context);
        ListTest.assertTrue((String)"wrong response array length", (appointmentArray.length >= 1 ? 1 : 0) != 0);
        loadContact = appointmentArray[0];
        contactObj.setObjectID(objectId);
        ListTest.compareObject(contactObj, loadContact);
        ListTest.deleteContact(this.getWebConversation(), objectId, this.contactFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testList() throws Exception {
        Contact contactObj = this.createContactObject("testObjectNotFound");
        int objectId = ListTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        int[] idArray = ListTest.listContact(this.getWebConversation(), this.contactFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        boolean found = false;
        for (int a = 0; a < idArray.length; ++a) {
            if (idArray[a] != objectId) continue;
            found = true;
            break;
        }
        ListTest.assertTrue((String)("id " + objectId + " not found in response"), (boolean)found);
        ListTest.deleteContact(this.getWebConversation(), objectId, this.contactFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }
}

