/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.TestException;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import com.openexchange.webdav.xml.AbstractWebdavXMLTest;
import com.openexchange.webdav.xml.AppointmentWriter;
import com.openexchange.webdav.xml.FolderTest;
import com.openexchange.webdav.xml.XmlServlet;
import com.openexchange.webdav.xml.parser.ResponseParser;
import com.openexchange.webdav.xml.request.PropFindMethod;
import com.openexchange.webdav.xml.types.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.SAXException;

public class AppointmentTest
extends AbstractWebdavXMLTest {
    protected int userId = -1;
    protected int userParticipantId2 = -1;
    protected int userParticipantId3 = -1;
    protected int groupParticipantId1 = -1;
    protected int resourceParticipantId1 = -1;
    protected int appointmentFolderId = -1;
    protected String userParticipant2 = null;
    protected String userParticipant3 = null;
    protected String groupParticipant = null;
    protected String resourceParticipant = null;
    protected Date startTime = null;
    protected Date endTime = null;
    @Deprecated
    private static final String APPOINTMENT_URL = "/servlet/webdav.calendar";

    public AppointmentTest(String name) {
        super(name);
    }

    protected static Date decrementDate(Date date) {
        return new Date(date.getTime() - 1L);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Calendar c = Calendar.getInstance();
        c.add(5, 1);
        c.set(11, 12);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        this.startTime = new Date(c.getTimeInMillis());
        this.endTime = new Date(this.startTime.getTime() + 3600000L);
        this.userParticipant2 = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"user_participant2", (String)"");
        this.userParticipant3 = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"user_participant3", (String)"");
        this.groupParticipant = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"group_participant", (String)"");
        this.resourceParticipant = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"resource_participant", (String)"");
        FolderObject folderObj = FolderTest.getAppointmentDefaultFolder(this.webCon, "http://" + this.hostName, this.login, this.password, this.context);
        this.appointmentFolderId = folderObj.getObjectID();
        this.userId = folderObj.getCreatedBy();
    }

    public static void compareObject(Appointment appointmentObj1, Appointment appointmentObj2) throws Exception {
        AppointmentTest.assertEquals((String)"id is not equals", (int)appointmentObj1.getObjectID(), (int)appointmentObj2.getObjectID());
        AppointmentTest.assertEqualsAndNotNull("title is not equals", appointmentObj1.getTitle(), appointmentObj2.getTitle());
        AppointmentTest.assertEqualsAndNotNull("start is not equals", appointmentObj1.getStartDate(), appointmentObj2.getStartDate());
        AppointmentTest.assertEqualsAndNotNull("end is not equals", appointmentObj1.getEndDate(), appointmentObj2.getEndDate());
        AppointmentTest.assertEqualsAndNotNull("location is not equals", appointmentObj1.getLocation(), appointmentObj2.getLocation());
        AppointmentTest.assertEquals((String)"shown_as is not equals", (int)appointmentObj1.getShownAs(), (int)appointmentObj2.getShownAs());
        AppointmentTest.assertEquals((String)"folder id is not equals", (int)appointmentObj1.getParentFolderID(), (int)appointmentObj2.getParentFolderID());
        AppointmentTest.assertEquals((String)"private flag is not equals", (boolean)appointmentObj1.getPrivateFlag(), (boolean)appointmentObj2.getPrivateFlag());
        AppointmentTest.assertEquals((String)"full time is not equals", (boolean)appointmentObj1.getFullTime(), (boolean)appointmentObj2.getFullTime());
        AppointmentTest.assertEquals((String)"label is not equals", (int)appointmentObj1.getLabel(), (int)appointmentObj2.getLabel());
        AppointmentTest.assertEquals((String)"alarm is not equals", (int)appointmentObj1.getAlarm(), (int)appointmentObj2.getAlarm());
        AppointmentTest.assertEquals((String)"alarm flag is not equals", (boolean)appointmentObj1.getAlarmFlag(), (boolean)appointmentObj2.getAlarmFlag());
        AppointmentTest.assertEquals((String)"recurrence_type", (int)appointmentObj1.getRecurrenceType(), (int)appointmentObj2.getRecurrenceType());
        AppointmentTest.assertEquals((String)"interval", (int)appointmentObj1.getInterval(), (int)appointmentObj2.getInterval());
        AppointmentTest.assertEquals((String)"days", (int)appointmentObj1.getDays(), (int)appointmentObj2.getDays());
        AppointmentTest.assertEquals((String)"month", (int)appointmentObj1.getMonth(), (int)appointmentObj2.getMonth());
        AppointmentTest.assertEquals((String)"day_in_month", (int)appointmentObj1.getDayInMonth(), (int)appointmentObj2.getDayInMonth());
        AppointmentTest.assertEquals((String)"until", (Object)appointmentObj1.getUntil(), (Object)appointmentObj2.getUntil());
        AppointmentTest.assertEqualsAndNotNull("note is not equals", appointmentObj1.getNote(), appointmentObj2.getNote());
        AppointmentTest.assertEqualsAndNotNull("categories is not equals", appointmentObj1.getCategories(), appointmentObj2.getCategories());
        AppointmentTest.assertEqualsAndNotNull("delete exception is not equals", appointmentObj1.getDeleteException(), appointmentObj2.getDeleteException());
        AppointmentTest.assertEqualsAndNotNull("participants are not equals", AppointmentTest.participants2String(appointmentObj1.getParticipants()), AppointmentTest.participants2String(appointmentObj2.getParticipants()));
        AppointmentTest.assertEqualsAndNotNull("users are not equals", AppointmentTest.users2String(appointmentObj1.getUsers()), AppointmentTest.users2String(appointmentObj2.getUsers()));
    }

    protected Appointment createAppointmentObject(String title) throws Exception {
        Appointment appointmentobject = new Appointment();
        appointmentobject.setTitle(title);
        appointmentobject.setStartDate(this.startTime);
        appointmentobject.setEndDate(this.endTime);
        appointmentobject.setLocation("Location");
        appointmentobject.setShownAs(3);
        appointmentobject.setParentFolderID(this.appointmentFolderId);
        return appointmentobject;
    }

    public static int insertAppointment(WebConversation webCon, Appointment appointmentObj, String host, String login, String password, String context) throws OXException, Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        int objectId = 0;
        appointmentObj.removeObjectID();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Element eProp = new Element("prop", webdav);
        AppointmentWriter appointmentWriter = new AppointmentWriter();
        appointmentWriter.addContent2PropElement(eProp, appointmentObj, false, true);
        Document doc = AppointmentTest.addProp2Document(eProp);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest(host + APPOINTMENT_URL, (InputStream)bais, "text/xml");
        req.setHeaderField("authorization", "Basic " + AppointmentTest.getAuthData(login, password, context));
        WebResponse resp = webCon.getResource((WebRequest)req);
        AppointmentTest.assertEquals((int)207, (int)resp.getResponseCode());
        bais = new ByteArrayInputStream(resp.getText().getBytes());
        Response[] response = ResponseParser.parse(new SAXBuilder().build((InputStream)bais), 1);
        AppointmentTest.assertEquals((String)"check response", (int)1, (int)response.length);
        if (response[0].hasError()) {
            throw new TestException(response[0].getErrorMessage());
        }
        AppointmentTest.assertEquals((String)"check response status", (int)200, (int)response[0].getStatus());
        appointmentObj = (Appointment)response[0].getDataObject();
        objectId = appointmentObj.getObjectID();
        AppointmentTest.assertNotNull((String)"last modified is null", (Object)appointmentObj.getLastModified());
        AppointmentTest.assertTrue((String)"last modified is not > 0", (appointmentObj.getLastModified().getTime() > 0L ? 1 : 0) != 0);
        AppointmentTest.assertTrue((String)"check objectId", (objectId > 0 ? 1 : 0) != 0);
        return objectId;
    }

    public static int updateAppointment(WebConversation webCon, Appointment appointmentObj, int objectId, int inFolder, String host, String login, String password, String context) throws OXException, Exception {
        return AppointmentTest.updateAppointment(webCon, appointmentObj, objectId, inFolder, new Date(System.currentTimeMillis() + 1000000L), host, login, password, context);
    }

    public static int updateAppointment(WebConversation webCon, Appointment appointmentObj, int objectId, int inFolder, Date lastModified, String host, String login, String password, String context) throws OXException, Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        appointmentObj.setObjectID(objectId);
        appointmentObj.setLastModified(lastModified);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Element eProp = new Element("prop", webdav);
        AppointmentWriter appointmentWriter = new AppointmentWriter();
        appointmentWriter.addContent2PropElement(eProp, appointmentObj, false, true);
        Document doc = AppointmentTest.addProp2Document(eProp);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest(host + APPOINTMENT_URL, (InputStream)bais, "text/javascript");
        req.setHeaderField("authorization", "Basic " + AppointmentTest.getAuthData(login, password, context));
        WebResponse resp = webCon.getResource((WebRequest)req);
        AppointmentTest.assertEquals((int)207, (int)resp.getResponseCode());
        bais = new ByteArrayInputStream(resp.getText().getBytes());
        Response[] response = ResponseParser.parse(new SAXBuilder().build((InputStream)bais), 1);
        AppointmentTest.assertEquals((String)"check response", (int)1, (int)response.length);
        if (response[0].hasError()) {
            throw new TestException(response[0].getErrorMessage());
        }
        appointmentObj = (Appointment)response[0].getDataObject();
        objectId = appointmentObj.getObjectID();
        AppointmentTest.assertNotNull((String)"last modified is null", (Object)appointmentObj.getLastModified());
        AppointmentTest.assertTrue((String)"last modified is not > 0", (appointmentObj.getLastModified().getTime() > 0L ? 1 : 0) != 0);
        AppointmentTest.assertEquals((String)"check response status", (int)200, (int)response[0].getStatus());
        return objectId;
    }

    public static void deleteAppointment(WebConversation webCon, int objectId, int inFolder, Date lastModified, Date recurrenceDatePosition, String host, String login, String password, String context) throws OXException, Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Element rootElement = new Element("multistatus", webdav);
        rootElement.addNamespaceDeclaration(XmlServlet.NS);
        UnsynchronizedByteArrayOutputStream baos = new UnsynchronizedByteArrayOutputStream();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setObjectID(objectId);
        appointmentObj.setParentFolderID(inFolder);
        appointmentObj.setLastModified(lastModified);
        appointmentObj.setRecurrenceDatePosition(recurrenceDatePosition);
        Element eProp = new Element("prop", webdav);
        AppointmentWriter appointmentWriter = new AppointmentWriter();
        appointmentWriter.addContent2PropElement(eProp, appointmentObj, false);
        Element eMethod = new Element("method", XmlServlet.NS);
        eMethod.addContent("DELETE");
        eProp.addContent((Content)eMethod);
        rootElement.addContent((Content)AppointmentTest.addProp2PropertyUpdate(eProp));
        Document doc = new Document(rootElement);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        Object bais = new UnsynchronizedByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest(host + APPOINTMENT_URL, (InputStream)bais, "text/xml");
        req.setHeaderField("authorization", "Basic " + AppointmentTest.getAuthData(login, password, context));
        WebResponse resp = webCon.getResponse((WebRequest)req);
        AppointmentTest.assertEquals((int)207, (int)resp.getResponseCode());
        bais = new ByteArrayInputStream(resp.getText().getBytes());
        Response[] response = ResponseParser.parse(new SAXBuilder().build((InputStream)bais), 1);
        if (response[0].hasError()) {
            throw new TestException(response[0].getErrorMessage());
        }
    }

    public static int[] deleteAppointment(WebConversation webCon, int[][] objectIdAndFolderId, String host, String login, String password, String context) throws Exception {
        new ArrayList();
        for (int a = 0; a < objectIdAndFolderId.length; ++a) {
            AppointmentTest.deleteAppointment(webCon, objectIdAndFolderId[a][0], objectIdAndFolderId[a][1], host, login, password, context);
        }
        return new int[0];
    }

    public static void deleteAppointment(WebConversation webCon, int objectId, int inFolder, String host, String login, String password, String context) throws OXException, Exception {
        AppointmentTest.deleteAppointment(webCon, objectId, inFolder, new Date(System.currentTimeMillis() + 1000000L), host, login, password, context);
    }

    public static void deleteAppointment(WebConversation webCon, int objectId, int inFolder, Date lastModified, String host, String login, String password, String context) throws OXException, Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Element rootElement = new Element("multistatus", webdav);
        rootElement.addNamespaceDeclaration(XmlServlet.NS);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setObjectID(objectId);
        appointmentObj.setParentFolderID(inFolder);
        appointmentObj.setLastModified(lastModified);
        Element eProp = new Element("prop", webdav);
        AppointmentWriter appointmentWriter = new AppointmentWriter();
        appointmentWriter.addContent2PropElement(eProp, appointmentObj, false);
        Element eMethod = new Element("method", XmlServlet.NS);
        eMethod.addContent("DELETE");
        eProp.addContent((Content)eMethod);
        rootElement.addContent((Content)AppointmentTest.addProp2PropertyUpdate(eProp));
        Document doc = new Document(rootElement);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest(host + APPOINTMENT_URL, (InputStream)bais, "text/xml");
        req.setHeaderField("authorization", "Basic " + AppointmentTest.getAuthData(login, password, context));
        WebResponse resp = webCon.getResource((WebRequest)req);
        AppointmentTest.assertEquals((int)207, (int)resp.getResponseCode());
        bais = new ByteArrayInputStream(resp.getText().getBytes());
        Response[] response = ResponseParser.parse(new SAXBuilder().build((InputStream)bais), 1);
        if (response[0].hasError()) {
            throw new TestException(response[0].getErrorMessage());
        }
    }

    public static void confirmAppointment(WebConversation webCon, int objectId, int confirm, String confirmMessage, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Element eProp = new Element("prop", webdav);
        Element eObjectId = new Element("object_id", XmlServlet.NS);
        eObjectId.addContent(String.valueOf(objectId));
        eProp.addContent((Content)eObjectId);
        Element eMethod = new Element("method", XmlServlet.NS);
        eMethod.addContent("CONFIRM");
        eProp.addContent((Content)eMethod);
        Element eConfirm = new Element("confirm", XmlServlet.NS);
        switch (confirm) {
            case 0: {
                eConfirm.addContent("none");
                break;
            }
            case 1: {
                eConfirm.addContent("accept");
                break;
            }
            case 2: {
                eConfirm.addContent("decline");
                break;
            }
            default: {
                eConfirm.addContent("invalid");
            }
        }
        eProp.addContent((Content)eConfirm);
        Document doc = AppointmentTest.addProp2Document(eProp);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest(host + APPOINTMENT_URL, (InputStream)bais, "text/javascript");
        req.setHeaderField("authorization", "Basic " + AppointmentTest.getAuthData(login, password, context));
        WebResponse resp = webCon.getResponse((WebRequest)req);
        AppointmentTest.assertEquals((int)207, (int)resp.getResponseCode());
        bais = new ByteArrayInputStream(resp.getText().getBytes());
        Response[] response = ResponseParser.parse(new SAXBuilder().build((InputStream)bais), 1);
        AppointmentTest.assertEquals((String)"check response", (int)1, (int)response.length);
        if (response[0].hasError()) {
            AppointmentTest.fail((String)("xml error: " + response[0].getErrorMessage()));
        }
        AppointmentTest.assertEquals((String)"check response status", (int)200, (int)response[0].getStatus());
    }

    public static int[] listAppointment(WebConversation webCon, int inFolder, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Element ePropfind = new Element("propfind", webdav);
        Element eProp = new Element("prop", webdav);
        Element eFolderId = new Element("folder_id", XmlServlet.NS);
        Element eObjectmode = new Element("objectmode", XmlServlet.NS);
        eFolderId.addContent(String.valueOf(inFolder));
        eObjectmode.addContent("LIST");
        eProp.addContent((Content)eFolderId);
        eProp.addContent((Content)eObjectmode);
        ePropfind.addContent((Content)eProp);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document doc = new Document(ePropfind);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.flush();
        HttpClient httpclient = new HttpClient();
        httpclient.getState().setCredentials(AuthScope.ANY, AppointmentTest.getCredentials(login, password, context));
        PropFindMethod propFindMethod = new PropFindMethod(host + APPOINTMENT_URL);
        propFindMethod.setDoAuthentication(true);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        propFindMethod.setRequestBody(bais);
        int status = httpclient.executeMethod((HttpMethod)propFindMethod);
        AppointmentTest.assertEquals((String)"check propfind response", (int)207, (int)status);
        InputStream body = propFindMethod.getResponseBodyAsStream();
        Response[] response = ResponseParser.parse(new SAXBuilder().build(body), 1, true);
        AppointmentTest.assertEquals((String)"response length not is 1", (int)1, (int)response.length);
        return (int[])response[0].getDataObject();
    }

    public static Appointment[] listAppointment(WebConversation webCon, int inFolder, Date modified, boolean changed, boolean deleted, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        if (!changed && !deleted) {
            return new Appointment[0];
        }
        Element ePropfind = new Element("propfind", webdav);
        Element eProp = new Element("prop", webdav);
        Element eFolderId = new Element("folder_id", XmlServlet.NS);
        Element eLastSync = new Element("lastsync", XmlServlet.NS);
        Element eObjectmode = new Element("objectmode", XmlServlet.NS);
        eFolderId.addContent(String.valueOf(inFolder));
        eLastSync.addContent(String.valueOf(modified.getTime()));
        StringBuffer objectMode = new StringBuffer();
        if (changed) {
            objectMode.append("NEW_AND_MODIFIED,");
        }
        if (deleted) {
            objectMode.append("DELETED,");
        }
        objectMode.delete(objectMode.length() - 1, objectMode.length());
        eObjectmode.addContent(objectMode.toString());
        eProp.addContent((Content)eObjectmode);
        ePropfind.addContent((Content)eProp);
        eProp.addContent((Content)eFolderId);
        eProp.addContent((Content)eLastSync);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document doc = new Document(ePropfind);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.flush();
        HttpClient httpclient = new HttpClient();
        httpclient.getState().setCredentials(AuthScope.ANY, AppointmentTest.getCredentials(login, password, context));
        PropFindMethod propFindMethod = new PropFindMethod(host + APPOINTMENT_URL);
        propFindMethod.setDoAuthentication(true);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        propFindMethod.setRequestBody(bais);
        int status = httpclient.executeMethod((HttpMethod)propFindMethod);
        AppointmentTest.assertEquals((String)"check propfind response", (int)207, (int)status);
        InputStream body = propFindMethod.getResponseBodyAsStream();
        Response[] response = ResponseParser.parse(new SAXBuilder().build(body), 1);
        Appointment[] appointmentArray = new Appointment[response.length];
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (response[a].hasError()) {
                AppointmentTest.fail((String)("xml error: " + response[a].getErrorMessage()));
            }
            appointmentArray[a] = (Appointment)response[a].getDataObject();
            AppointmentTest.assertNotNull((String)"last modified is null", (Object)appointmentArray[a].getLastModified());
        }
        return appointmentArray;
    }

    public static Appointment loadAppointment(WebConversation webCon, int objectId, int inFolder, Date modified, String host, String login, String password, String context) throws OXException, Exception {
        Appointment[] appointmentArray = AppointmentTest.listAppointment(webCon, inFolder, modified, true, false, host, login, password, context);
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId) continue;
            return appointmentArray[a];
        }
        throw new TestException("object not found");
    }

    public static Appointment loadAppointment(WebConversation webCon, int objectId, int inFolder, String host, String login, String password, String context) throws OXException, Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Element ePropfind = new Element("propfind", webdav);
        Element eProp = new Element("prop", webdav);
        Element eFolderId = new Element("folder_id", XmlServlet.NS);
        Element eObjectId = new Element("object_id", XmlServlet.NS);
        eFolderId.addContent(String.valueOf(inFolder));
        eObjectId.addContent(String.valueOf(objectId));
        ePropfind.addContent((Content)eProp);
        eProp.addContent((Content)eFolderId);
        eProp.addContent((Content)eObjectId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document doc = new Document(ePropfind);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.flush();
        HttpClient httpclient = new HttpClient();
        httpclient.getState().setCredentials(AuthScope.ANY, AppointmentTest.getCredentials(login, password, context));
        PropFindMethod propFindMethod = new PropFindMethod(host + APPOINTMENT_URL);
        propFindMethod.setDoAuthentication(true);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        propFindMethod.setRequestBody(bais);
        int status = httpclient.executeMethod((HttpMethod)propFindMethod);
        AppointmentTest.assertEquals((String)"check propfind response", (int)207, (int)status);
        InputStream body = propFindMethod.getResponseBodyAsStream();
        Response[] response = ResponseParser.parse(new SAXBuilder().build(body), 1);
        AppointmentTest.assertEquals((String)"check response", (int)1, (int)response.length);
        if (response[0].hasError()) {
            throw new TestException(response[0].getErrorMessage());
        }
        AppointmentTest.assertEquals((String)"check response status", (int)200, (int)response[0].getStatus());
        return (Appointment)response[0].getDataObject();
    }

    private static Credentials getCredentials(String login, String password, String context) {
        return new UsernamePasswordCredentials(context == null || context.equals("") ? login : login + "@" + context, password);
    }

    protected int getFreeBusyState(WebConversation webCon, String contextid, String username, String context, Date start, Date end) throws IOException, SAXException {
        String url = "http://" + this.getHostName() + "/servlet/webdav.freebusy?contextid=" + contextid + "&username=" + username + "&server=" + context + "&start=" + start.getTime() + "&end=" + end.getTime();
        GetMethodWebRequest request = new GetMethodWebRequest(url);
        WebResponse response = webCon.getResponse((WebRequest)request);
        String text = response.getText();
        System.out.println(text);
        return -1;
    }

    private static HashSet participants2String(Participant[] participant) throws Exception {
        if (participant == null) {
            return null;
        }
        HashSet<String> hs = new HashSet<String>();
        for (int a = 0; a < participant.length; ++a) {
            hs.add(AppointmentTest.participant2String(participant[a]));
        }
        return hs;
    }

    private static String participant2String(Participant p) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("T" + p.getType());
        sb.append("ID" + p.getIdentifier());
        if (p instanceof ExternalUserParticipant) {
            ExternalUserParticipant externalUserParticipant = (ExternalUserParticipant)p;
            sb.append("MAIL" + externalUserParticipant.getEmailAddress());
        }
        return sb.toString();
    }

    private static HashSet users2String(UserParticipant[] users) throws Exception {
        if (users == null) {
            return null;
        }
        HashSet<String> hs = new HashSet<String>();
        for (int a = 0; a < users.length; ++a) {
            hs.add(AppointmentTest.user2String(users[a]));
        }
        return hs;
    }

    private static String user2String(UserParticipant user) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("ID" + user.getIdentifier());
        sb.append("C" + user.getConfirm());
        return sb.toString();
    }
}

