/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol;

import com.openexchange.exception.OXException;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavCollection;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.protocol.util.PropertySwitch;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;

public abstract class AbstractResourceTest
extends TestCase
implements PropertySwitch {
    public static final int SKEW = 1000;
    protected WebdavFactory resourceManager;
    protected WebdavPath testCollection = new WebdavPath(new String[]{"public_infostore", "testCollection" + Math.random()});

    protected abstract WebdavFactory getWebdavFactory() throws Exception;

    protected abstract List<Protocol.Property> getPropertiesToTest() throws Exception;

    protected abstract WebdavResource createResource() throws Exception;

    public void setUp() throws Exception {
        this.resourceManager = this.getWebdavFactory();
        WebdavCollection resource = this.resourceManager.resolveCollection(this.testCollection);
        AbstractResourceTest.assertTrue((boolean)resource.isCollection());
        resource.create();
    }

    public void tearDown() throws Exception {
        this.resourceManager.resolveCollection(this.testCollection).delete();
    }

    public void testProperties() throws Exception {
        WebdavResource res = this.createResource();
        WebdavProperty prop = new WebdavProperty();
        prop.setNamespace("OXTest");
        prop.setName("myvalue");
        prop.setLanguage("en");
        prop.setValue("testValue");
        res.putProperty(prop);
        res.save();
        res = this.resourceManager.resolveResource(res.getUrl());
        AbstractResourceTest.assertEquals((Object)prop, (Object)res.getProperty("OXTest", "myvalue"));
        prop = new WebdavProperty();
        prop.setNamespace("OXTest");
        prop.setName("myvalue");
        prop.setLanguage("en");
        prop.setValue("testValue2");
        res.putProperty(prop);
        res.save();
        res = this.resourceManager.resolveResource(res.getUrl());
        AbstractResourceTest.assertEquals((Object)prop, (Object)res.getProperty("OXTest", "myvalue"));
        res.removeProperty("OXTest", "myvalue");
        res.save();
        AbstractResourceTest.assertNull((Object)res.getProperty("OXTest", "myvalue"));
    }

    public void testMandatoryProperties() throws Exception {
        List<Protocol.Property> mandatory = this.getPropertiesToTest();
        for (Protocol.Property prop : mandatory) {
            prop.doSwitch((PropertySwitch)this);
        }
    }

    public void testCreateLoadAndDelete() throws Exception {
        WebdavResource resource = this.createResource();
        AbstractResourceTest.assertTrue((boolean)resource.exists());
        resource.delete();
        resource = this.resourceManager.resolveResource(resource.getUrl());
        AbstractResourceTest.assertFalse((boolean)resource.exists());
    }

    public static void assertEquals(Date d1, Date d2, int skew) {
        long l2;
        long diff;
        long l1 = d1.getTime();
        long l = diff = l1 < (l2 = d2.getTime()) ? l2 - l1 : l1 - l2;
        if (diff > (long)skew) {
            AbstractResourceTest.assertEquals((long)l1, (long)l2);
        }
        AbstractResourceTest.assertTrue((boolean)true);
    }

    public static void assertResources(Iterable<WebdavResource> resources, String ... displayNames) throws OXException {
        HashSet<String> nameSet = new HashSet<String>(Arrays.asList(displayNames));
        for (WebdavResource res : resources) {
            AbstractResourceTest.assertTrue((String)(res.getDisplayName() + " not expected"), (boolean)nameSet.remove(res.getDisplayName()));
        }
        AbstractResourceTest.assertTrue((String)((Object)nameSet).toString(), (boolean)nameSet.isEmpty());
    }

    public static void assertOptions(Iterable<Protocol.WEBDAV_METHOD> expect, Protocol.WEBDAV_METHOD ... methods) throws OXException {
        HashSet<Protocol.WEBDAV_METHOD> methodSet = new HashSet<Protocol.WEBDAV_METHOD>(Arrays.asList(methods));
        for (Protocol.WEBDAV_METHOD method : expect) {
            AbstractResourceTest.assertTrue((String)(method + " not expected"), (boolean)methodSet.remove(method));
        }
        AbstractResourceTest.assertTrue((String)((Object)methodSet).toString(), (boolean)methodSet.isEmpty());
    }

    public void throwEx(OXException x) throws OXException {
        throw new WebdavProtocolException(new WebdavPath(new String[0]), 500, x);
    }
}

