/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures.transformators;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.SimpleCredentials;
import com.openexchange.test.fixtures.transformators.Transformator;
import java.util.ArrayList;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.idn.IDNA;

public class DistributionListTransformator
implements Transformator {
    private final FixtureLoader fixtureLoader;

    public DistributionListTransformator(FixtureLoader fixtureLoader) {
        this.fixtureLoader = fixtureLoader;
    }

    @Override
    public Object transform(String value) throws OXException {
        if (null == value || 1 > value.length()) {
            return null;
        }
        String fixtureName = "users";
        String fixtureEntry = "";
        String[] splitted = value.split(",");
        ArrayList<DistributionListEntryObject> distributionListEntries = new ArrayList<DistributionListEntryObject>(splitted.length);
        for (int i = 0; i < splitted.length; ++i) {
            int idx = splitted[i].indexOf(58);
            if (0 < idx && splitted[i].length() > idx) {
                fixtureName = splitted[i].substring(0, idx);
                fixtureEntry = splitted[i].substring(idx + 1);
            } else {
                fixtureEntry = splitted[i];
            }
            distributionListEntries.add(this.getDistributionListEntry(fixtureName, fixtureEntry));
        }
        return distributionListEntries.toArray(new DistributionListEntryObject[distributionListEntries.size()]);
    }

    private DistributionListEntryObject getDistributionListEntry(String fixtureName, String fixtureEntry) throws OXException {
        if ("users".equals(fixtureName)) {
            return this.getUserDistributionListEntry(fixtureName, fixtureEntry);
        }
        if ("contacts".equals(fixtureName)) {
            return this.getContactDistributionListEntry(fixtureName, fixtureEntry);
        }
        if ("custom".equals(fixtureName)) {
            return this.getCustomDistributionListEntry(fixtureName, fixtureEntry);
        }
        throw OXException.general((String)("Unable to convert " + fixtureName + ":" + fixtureEntry + " into a distribution list entry."));
    }

    private DistributionListEntryObject getContactDistributionListEntry(String fixtureName, String fixtureEntry) throws OXException {
        Contact contact = this.fixtureLoader.getFixtures(fixtureName, Contact.class).getEntry(fixtureEntry).getEntry();
        String email = null;
        if (contact.containsEmail1()) {
            email = contact.getEmail1();
        } else if (contact.containsEmail2()) {
            email = contact.getEmail2();
        } else if (contact.containsEmail3()) {
            email = contact.getEmail3();
        }
        if (null == email) {
            throw OXException.general((String)"Contacts must contain an email address");
        }
        return new DistributionListEntryObject(contact.getDisplayName(), email, 0);
    }

    private DistributionListEntryObject getUserDistributionListEntry(String fixtureName, String fixtureEntry) throws OXException {
        Contact user = this.fixtureLoader.getFixtures(fixtureName, SimpleCredentials.class).getEntry(fixtureEntry).getEntry().asContact();
        DistributionListEntryObject entry = new DistributionListEntryObject();
        entry.setDisplayname(user.getDisplayName());
        entry.setEmailaddress(user.getEmail1());
        entry.setEntryID(0);
        return entry;
    }

    private DistributionListEntryObject getCustomDistributionListEntry(String fixtureName, String fixtureEntry) throws OXException {
        InternetAddress address = null;
        try {
            InternetAddress[] addresses = InternetAddress.parse((String)fixtureEntry);
            if (null == addresses || 1 > addresses.length || null == addresses[0]) {
                throw OXException.general((String)("unable to parse custom distributionlist entry from " + fixtureEntry));
            }
            address = addresses[0];
        }
        catch (AddressException e) {
            throw OXException.general((String)("unable to parse custom distributionlist entry from " + fixtureEntry + ": " + e.getMessage()));
        }
        return new DistributionListEntryObject(address.getPersonal(), IDNA.toIDN((String)address.getAddress()), 0);
    }
}

