/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.messagestorage;

import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.IndexRange;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.permission.MailPermission;
import com.openexchange.mail.search.BodyTerm;
import com.openexchange.mail.search.ComparisonType;
import com.openexchange.mail.search.FlagTerm;
import com.openexchange.mail.search.FromTerm;
import com.openexchange.mail.search.HeaderTerm;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SentDateTerm;
import com.openexchange.mail.search.SizeTerm;
import com.openexchange.mail.search.SubjectTerm;
import com.openexchange.mail.search.ToTerm;
import com.openexchange.mail.utils.DateUtils;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.mail.MessagingException;

public final class MailSearchTest
extends AbstractMailTest {
    private static final MailField[] FIELDS_ID = new MailField[]{MailField.ID};
    private static final MailField[] FIELDS_ID_AND_HEADER = new MailField[]{MailField.ID, MailField.HEADERS};
    private static final MailField[] FIELDS_MORE = new MailField[]{MailField.ID, MailField.CONTENT_TYPE, MailField.FLAGS};
    private static final MailField[] FIELDS_EVEN_MORE = new MailField[]{MailField.ID, MailField.CONTENT_TYPE, MailField.FLAGS, MailField.FROM, MailField.TO, MailField.DISPOSITION_NOTIFICATION_TO, MailField.COLOR_LABEL, MailField.HEADERS, MailField.SUBJECT, MailField.THREAD_LEVEL, MailField.SIZE, MailField.PRIORITY};
    private static final MailField[] FIELDS_FULL = new MailField[]{MailField.FULL};
    private static final String RFC822_SRC = "Return-Path: <dream-team-bounces@open-xchange.com>\nReceived: from ox.netline-is.de ([unix socket])\n\tby ox (Cyrus v2.2.3) with LMTP; Tue, 08 Apr 2008 10:33:24 +0200\nX-Sieve: CMU Sieve 2.2\nReceived: by ox.netline-is.de (Postfix, from userid 65534)\n\tid B46993DCB9E; Tue,  8 Apr 2008 10:33:23 +0200 (CEST)\nReceived: from netline.de (comfire.netline.de [192.168.32.1])\n\tby ox.netline-is.de (Postfix) with ESMTP id 70E1A3DCB9A\n\tfor <thorben@open-xchange.com>; Tue,  8 Apr 2008 10:33:22 +0200 (CEST)\nReceived: from [10.20.30.11] (helo=www.open-xchange.org ident=mail)\n\tby netline.de with esmtp (Exim)\n\tid 1Jj95z-0003bM-00\n\tfor thorben@open-xchange.com; Tue, 08 Apr 2008 10:22:23 +0200\nReceived: from mail.open-xchange.com ([10.20.30.22] helo=ox.open-xchange.com)\n\tby www.open-xchange.org with esmtp (Exim 3.36 #1 (Debian))\n\tid 1Jj9Fo-000709-00\n\tfor <thorben@open-xchange.org>; Tue, 08 Apr 2008 10:32:32 +0200\nReceived: by ox.open-xchange.com (Postfix, from userid 76)\n\tid D038132C89D; Tue,  8 Apr 2008 10:32:31 +0200 (CEST)\nReceived: from ox.open-xchange.com ([unix socket])\n\t by ox.open-xchange.com (Cyrus v2.2.12-Invoca-RPM-2.2.12-8.1.RHEL4) with LMTPA;\n\t Tue, 08 Apr 2008 10:32:29 +0200\nX-Sieve: CMU Sieve 2.2\nReceived: by ox.open-xchange.com (Postfix, from userid 99)\n\tid B862832C87B; Tue,  8 Apr 2008 10:32:25 +0200 (CEST)\nReceived: from ox.open-xchange.com (localhost.localdomain [127.0.0.1])\n\tby ox.open-xchange.com (Postfix) with ESMTP id C7C6632C60D;\n\tTue,  8 Apr 2008 10:32:24 +0200 (CEST)\nX-Original-To: dream-team@ox.open-xchange.com\nDelivered-To: dream-team@ox.open-xchange.com\nReceived: by ox.open-xchange.com (Postfix, from userid 99)\n\tid C263B32C8A3; Tue,  8 Apr 2008 10:32:22 +0200 (CEST)\nReceived: from netline.de (mail.netline-is.de [10.20.30.2])\n\tby ox.open-xchange.com (Postfix) with ESMTP id 5E96D32C87C;\n\tTue,  8 Apr 2008 10:32:20 +0200 (CEST)\nReceived: from [192.168.32.7] (helo=ox.netline-is.de)\n\tby netline.de with esmtp (Exim)\n\tid 1Jj95n-0003af-00; Tue, 08 Apr 2008 10:22:11 +0200\nReceived: by ox.netline-is.de (Postfix, from userid 65534)\n\tid 8A38F3DCB91; Tue,  8 Apr 2008 10:33:08 +0200 (CEST)\nReceived: from oxee (unknown [192.168.32.9])\n\tby ox.netline-is.de (Postfix) with ESMTP id 0657B3DCB89;\n\tTue,  8 Apr 2008 10:33:08 +0200 (CEST)\nDate: Tue, 8 Apr 2008 10:32:18 +0200 (CEST)\nFrom: \"Di Lella, Leonardo\" <leonardo.dilella@open-xchange.com>\nTo: dream-team@open-xchange.com,\n\tHolger Achtziger <Holger.Achtziger@open-xchange.com>\nMessage-ID: <32496175.17311207643539009.JavaMail.open-xchange@oxee>\nIn-Reply-To: <47F662C4.5060605@open-xchange.com>\nReferences: <47F662C4.5060605@open-xchange.com>\nSubject: =?UTF-8?Q?Re:_[dream-team]_Vserver_von_1und1_f=C3=BCr_alle_OX_Mitarbeiter?=\nMIME-Version: 1.0\nContent-Type: multipart/alternative; \n\tboundary=\"----=_Part_932_16478682.1207643538866\"\nX-Priority: 3\nX-Mailer: Open-Xchange Mailer v6.5.0-6342\nX-Scanner: exiscan *1Jj95n-0003af-00*Nlh5NV02rM6*\n\thttp://duncanthrax.net/exiscan/\nCc: \nX-BeenThere: dream-team@open-xchange.com\nX-Mailman-Version: 2.1.5\nPrecedence: list\nList-Id: Mailinglist for whole the dream-team of Open-Xchange - all members of\n\tOpen-Change <dream-team.open-xchange.com>\nList-Unsubscribe: <https://ox.open-xchange.com/mailman/listinfo/dream-team>,\n\t<mailto:dream-team-request@open-xchange.com?subject=unsubscribe>\nList-Archive: <https://ox.open-xchange.com/pipermail/dream-team>\nList-Post: <mailto:dream-team@open-xchange.com>\nList-Help: <mailto:dream-team-request@open-xchange.com?subject=help>\nList-Subscribe: <https://ox.open-xchange.com/mailman/listinfo/dream-team>,\n\t<mailto:dream-team-request@open-xchange.com?subject=subscribe>\nSender: dream-team-bounces@open-xchange.com\nErrors-To: dream-team-bounces@open-xchange.com\nX-Scanner: exiscan *1Jj95z-0003bM-00*HSfWvPhKQvA* http://duncanthrax.net/exiscan/\nX-Spam-Checker-Version: SpamAssassin 2.64 (2004-01-11) on ox.netline-is.de\nX-Spam-Level: \nX-Spam-Status: No, hits=-4.2 required=5.0 tests=AWL,BAYES_00,HTML_30_40,\n\tHTML_MESSAGE,HTML_TITLE_EMPTY autolearn=no version=2.64\n\n------=_Part_932_16478682.1207643538866\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\nHolger Achtziger <Holger.Achtziger@open-xchange.com> hat am 4. April 2008 um 19:17 geschrieben:\n\n> Hallo!\n\nHallo,\n\nwie lauten die Randbedingungen ? \n\n1) Wie lange zahlt uns 1&1 den Server (nur einen Jahr?) ?\n2) Privat oder nur geschaeftlich einsetzbar ?\n3) Was passiert bei einer OX-Kuendigung ?\n\nDanke.\n\n--\nbest regards\nLeonardo Di Lella\n\nOpen-Xchange GmbH\nhttp://www.open-xchange.com/wiki/index.php?title=User:Ledil\n\n[ledil (irc), leonardo_dilella (skype)]\n0x15208141 | 2829 F2BE 2242 91F0 24EB C0A7 258E F1A2 1520 8141\n------=_Part_932_16478682.1207643538866\nMIME-Version: 1.0\nContent-Type: text/html; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\n\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n  <head>\n    <meta content=\"text/html; charset=UTF-8\" http-equiv=\"Content-Type\">\n    <meta name=\"generator\"\n    content=\"HTML Tidy for Java (vers. 26 Sep 2004), see www.w3.org\" />\n\n    <title></title>\n  </head>\n\n  <body>\n    Holger Achtziger &lt;Holger.Achtziger@open-xchange.com&gt; hat am\n    4. April 2008 um 19:17 geschrieben:<br />\n    <br />\n    &gt; Hallo!<br />\n    <br />\n    Hallo,<br />\n    <br />\n    wie lauten die Randbedingungen ? <br />\n    <br />\n    1) Wie lange zahlt uns 1&amp;1 den Server (nur einen Jahr?) ?<br />\n    2) Privat oder nur geschaeftlich einsetzbar ?<br />\n    3) Was passiert bei einer OX-Kuendigung ?<br />\n    <br />\n    Danke.<br />\n    <br />\n\n    <div>\n      --<br />\n      best regards<br />\n      Leonardo Di Lella<br />\n      <br />\n      Open-Xchange GmbH<br />\n      <a\n      href=\"http://www.open-xchange.com/wiki/index.php?title=User:Ledil\"\n       target=\"_blank\">http://www.open-xchange.com/wiki/index.php?title=User:Ledil</a><br />\n      <br />\n      [ledil (irc), leonardo_dilella (skype)]<br />\n      0x15208141 | 2829 F2BE 2242 91F0 24EB C0A7 258E F1A2 1520 8141\n    </div>\n  </body>\n\n</html>\n\n------=_Part_932_16478682.1207643538866--\n\n";

    public MailSearchTest() {
    }

    public MailSearchTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailSearch() throws OXException, MessagingException, IOException {
        SessionObject session = this.getSession();
        MailMessage[] mails = MailSearchTest.getMessages(this.getTestMailDir(), -1);
        MailAccess mailAccess = MailAccess.getInstance((Session)session);
        mailAccess.connect();
        String[] uids = mailAccess.getMessageStorage().appendMessages("INBOX", mails);
        try {
            int i;
            HeaderTerm term = new HeaderTerm("Content-Type", "text/plain; charset=us-ascii");
            System.currentTimeMillis();
            MailMessage[] fetchedMails = mailAccess.getMessageStorage().searchMessages("INBOX", IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            for (i = 0; i < fetchedMails.length; ++i) {
                MailSearchTest.assertFalse((String)"Mail ID is -1", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
            }
            term = new FlagTerm(32, false);
            System.currentTimeMillis();
            fetchedMails = mailAccess.getMessageStorage().searchMessages("INBOX", IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_MORE);
            for (i = 0; i < fetchedMails.length; ++i) {
                MailSearchTest.assertFalse((String)"Missing mail ID", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                MailSearchTest.assertTrue((String)"Missing content type", (boolean)fetchedMails[i].containsContentType());
                MailSearchTest.assertTrue((String)"Missing flags", (boolean)fetchedMails[i].containsFlags());
                MailSearchTest.assertTrue((String)"Message contains flag \\Seen although only unseen messages should have been returned", ((fetchedMails[i].getFlags() & 0x20) == 0 ? 1 : 0) != 0);
            }
            term = new SizeTerm(ComparisonType.GREATER_THAN, 1023);
            System.currentTimeMillis();
            fetchedMails = mailAccess.getMessageStorage().searchMessages("INBOX", IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_EVEN_MORE);
            for (i = 0; i < fetchedMails.length; ++i) {
                MailSearchTest.assertFalse((String)"Missing mail ID", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                MailSearchTest.assertTrue((String)"Missing content type", (boolean)fetchedMails[i].containsContentType());
                MailSearchTest.assertTrue((String)"Missing flags", (boolean)fetchedMails[i].containsFlags());
                MailSearchTest.assertTrue((String)"Missing From", (boolean)fetchedMails[i].containsFrom());
                MailSearchTest.assertTrue((String)"Missing To", (boolean)fetchedMails[i].containsTo());
                MailSearchTest.assertTrue((String)"Missing Disposition-Notification-To", (boolean)fetchedMails[i].containsDispositionNotification());
                MailSearchTest.assertTrue((String)"Missing color label", (boolean)fetchedMails[i].containsColorLabel());
                MailSearchTest.assertTrue((String)"Missing headers", (boolean)fetchedMails[i].containsHeaders());
                MailSearchTest.assertTrue((String)"Missing subject", (boolean)fetchedMails[i].containsSubject());
                MailSearchTest.assertTrue((String)"Missing thread level", (boolean)fetchedMails[i].containsThreadLevel());
                MailSearchTest.assertTrue((String)"Missing size", (boolean)fetchedMails[i].containsSize());
                MailSearchTest.assertTrue((String)"Missing priority", (boolean)fetchedMails[i].containsPriority());
            }
            HashMap<String, String> map = new HashMap<String, String>(fetchedMails.length);
            for (int i2 = 0; i2 < fetchedMails.length && i2 < 100; ++i2) {
                String messageId = fetchedMails[i2].getFirstHeader("Message-ID");
                if (null == messageId || messageId.length() <= 0 || "null".equalsIgnoreCase(messageId)) continue;
                map.put(fetchedMails[i2].getMailId(), messageId);
            }
            int size = map.size();
            Iterator iter = map.entrySet().iterator();
            for (int i3 = 0; i3 < size; ++i3) {
                Map.Entry e = iter.next();
                term = new HeaderTerm("Message-ID", (String)e.getValue());
                System.currentTimeMillis();
                MailMessage[] searchedMails = mailAccess.getMessageStorage().searchMessages("INBOX", IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID_AND_HEADER);
                MailSearchTest.assertTrue((String)"Search failed: No result", (null != searchedMails ? 1 : 0) != 0);
                MailSearchTest.assertTrue((String)"Search failed: Non-matching result size", (searchedMails.length >= 1 ? 1 : 0) != 0);
                boolean found = false;
                for (int j = 0; j < searchedMails.length && !found; ++j) {
                    String messageId = searchedMails[j].getFirstHeader("Message-ID");
                    MailSearchTest.assertTrue((String)"Missing Message-Id", (null != messageId ? 1 : 0) != 0);
                    MailSearchTest.assertTrue((String)"Non-matching Message-Id", (boolean)messageId.equals(e.getValue()));
                    found = ((String)e.getKey()).equals(searchedMails[j].getMailId());
                }
                MailSearchTest.assertTrue((String)"Non-matching mail ID", (boolean)found);
            }
        }
        finally {
            mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
            mailAccess.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailSearchSmallMailbox() throws OXException, MessagingException, IOException {
        String parentFullname;
        SessionObject session = this.getSession();
        MailAccess mailAccess = MailAccess.getInstance((Session)session);
        mailAccess.connect();
        String name = "TemporaryFolder";
        String fullname = null;
        MailFolder inbox = mailAccess.getFolderStorage().getFolder("INBOX");
        if (inbox.isHoldsFolders()) {
            fullname = inbox.getFullname() + inbox.getSeparator() + "TemporaryFolder";
            parentFullname = "INBOX";
        } else {
            fullname = "TemporaryFolder";
            parentFullname = "default";
        }
        MailFolderDescription mfd = new MailFolderDescription();
        mfd.setExists(false);
        mfd.setParentFullname(parentFullname);
        mfd.setSeparator(inbox.getSeparator());
        mfd.setSubscribed(false);
        mfd.setName("TemporaryFolder");
        MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
        p.setEntity(this.getUser());
        p.setAllPermission(128, 128, 128, 128);
        p.setFolderAdmin(true);
        p.setGroupPermission(false);
        mfd.addPermission(p);
        mailAccess.getFolderStorage().createFolder(mfd);
        try {
            int i;
            int i2;
            mailAccess.getMessageStorage().appendMessages(fullname, MailSearchTest.getMessages(this.getTestMailDir(), -1));
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])RFC822_SRC.getBytes(Charsets.US_ASCII));
            MailSearchTest.assertEquals((String)"Unexpected or missing Message-ID header: ", (String)"<32496175.17311207643539009.JavaMail.open-xchange@oxee>", (String)mail.getFirstHeader("Message-ID"));
            String uid = mailAccess.getMessageStorage().appendMessages(fullname, new MailMessage[]{mail})[0];
            ToTerm term = new ToTerm("dream-team@open-xchange.com");
            MailMessage[] result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            boolean found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by To search term", (boolean)found);
            term = new FromTerm("\"Di Lella, Leonardo\" <leonardo.dilella@open-xchange.com>");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by From search term", (boolean)found);
            term = new FromTerm("Di Lella");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by From search term", (boolean)found);
            term = new SubjectTerm("Vserver von 1und1");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by Subject search term", (boolean)found);
            term = new SentDateTerm(ComparisonType.GREATER_THAN, DateUtils.getDateRFC822((String)"Tue, 8 Apr 2008 10:30:18 +0200 (CEST)"));
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by Sent Date search term", (boolean)found);
            term = new HeaderTerm("X-Priority", String.valueOf(3));
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by Header \"X-Priority\" search term", (boolean)found);
            term = new HeaderTerm("In-Reply-To", "<47F662C4.5060605@open-xchange.com>");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            MailSearchTest.assertTrue((String)("Unexpected result size: " + result.length), (result.length == 1 ? 1 : 0) != 0);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by Header \"In-Reply-To\" search term", (boolean)found);
            term = new BodyTerm("4. April 2008 um 19:17 geschrieben");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by body search term", (boolean)found);
            long size = mailAccess.getMessageStorage().getMessage(fullname, uid, false).getSize();
            term = new SizeTerm(ComparisonType.GREATER_THAN, (int)(size - 10L));
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i = 0; i < result.length && !found; ++i) {
                found = null != result[i].getMailId() && result[i].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by size search term", (boolean)found);
            term = new SizeTerm(ComparisonType.LESS_THAN, (int)(size + 10L));
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i = 0; i < result.length && !found; ++i) {
                found = null != result[i].getMailId() && result[i].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by size search term", (boolean)found);
            term = new SizeTerm(ComparisonType.EQUALS, (int)size);
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i = 0; i < result.length && !found; ++i) {
                found = null != result[i].getMailId() && result[i].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by size search term", (boolean)found);
        }
        finally {
            if (fullname != null) {
                mailAccess.getFolderStorage().deleteFolder(fullname, true);
            }
            mailAccess.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailSearchLargeMailbox() throws OXException, MessagingException, IOException {
        String parentFullname;
        SessionObject session = this.getSession();
        MailAccess mailAccess = MailAccess.getInstance((Session)session);
        mailAccess.connect();
        String name = "TemporaryFolder";
        String fullname = null;
        MailFolder inbox = mailAccess.getFolderStorage().getFolder("INBOX");
        if (inbox.isHoldsFolders()) {
            fullname = inbox.getFullname() + inbox.getSeparator() + "TemporaryFolder";
            parentFullname = "INBOX";
        } else {
            fullname = "TemporaryFolder";
            parentFullname = "default";
        }
        MailFolderDescription mfd = new MailFolderDescription();
        mfd.setExists(false);
        mfd.setParentFullname(parentFullname);
        mfd.setSeparator(inbox.getSeparator());
        mfd.setSubscribed(false);
        mfd.setName("TemporaryFolder");
        MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
        p.setEntity(this.getUser());
        p.setAllPermission(128, 128, 128, 128);
        p.setFolderAdmin(true);
        p.setGroupPermission(false);
        mfd.addPermission(p);
        mailAccess.getFolderStorage().createFolder(mfd);
        try {
            int i;
            int i2;
            MailMessage[] mails = MailSearchTest.getMessages(this.getTestMailDir(), -1);
            int breakEven = MailProperties.getInstance().getMailFetchLimit();
            String[] uids = mailAccess.getMessageStorage().appendMessages(fullname, mails);
            for (int count = mails.length; count < breakEven; count += uids.length) {
                mailAccess.getMessageStorage().copyMessages(fullname, fullname, uids, true);
            }
            mailAccess.getMessageStorage().appendMessages(fullname, mails);
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])RFC822_SRC.getBytes(Charsets.US_ASCII));
            String uid = mailAccess.getMessageStorage().appendMessages(fullname, new MailMessage[]{mail})[0];
            ToTerm term = new ToTerm("dream-team@open-xchange.com");
            MailMessage[] result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            boolean found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by To search term", (boolean)found);
            term = new FromTerm("\"Di Lella, Leonardo\" <leonardo.dilella@open-xchange.com>");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by From search term", (boolean)found);
            term = new FromTerm("Di Lella");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by From search term", (boolean)found);
            term = new SubjectTerm("Vserver von 1und1");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by Subject search term", (boolean)found);
            term = new SentDateTerm(ComparisonType.GREATER_THAN, DateUtils.getDateRFC822((String)"Tue, 8 Apr 2008 10:30:18 +0200 (CEST)"));
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by Sent Date search term", (boolean)found);
            term = new HeaderTerm("X-Priority", String.valueOf(3));
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by Header \"X-Priority\" search term", (boolean)found);
            term = new HeaderTerm("In-Reply-To", "<47F662C4.5060605@open-xchange.com>");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            MailSearchTest.assertTrue((String)("Unexpected result size: " + result.length), (result.length == 1 ? 1 : 0) != 0);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by Header \"In-Reply-To\" search term", (boolean)found);
            term = new BodyTerm("4. April 2008 um 19:17 geschrieben");
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i2 = 0; i2 < result.length && !found; ++i2) {
                found = null != result[i2].getMailId() && result[i2].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by body search term", (boolean)found);
            long size = mailAccess.getMessageStorage().getMessage(fullname, uid, false).getSize();
            term = new SizeTerm(ComparisonType.GREATER_THAN, (int)(size - 10L));
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i = 0; i < result.length && !found; ++i) {
                found = null != result[i].getMailId() && result[i].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by size search term", (boolean)found);
            term = new SizeTerm(ComparisonType.LESS_THAN, (int)(size + 10L));
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i = 0; i < result.length && !found; ++i) {
                found = null != result[i].getMailId() && result[i].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by size search term", (boolean)found);
            term = new SizeTerm(ComparisonType.EQUALS, (int)size);
            result = mailAccess.getMessageStorage().searchMessages(fullname, IndexRange.NULL, null, null, (SearchTerm)term, FIELDS_ID);
            found = false;
            for (i = 0; i < result.length && !found; ++i) {
                found = null != result[i].getMailId() && result[i].getMailId().equals(uid);
            }
            MailSearchTest.assertTrue((String)"Message not found by size search term", (boolean)found);
        }
        finally {
            if (fullname != null) {
                mailAccess.getFolderStorage().deleteFolder(fullname, true);
            }
            mailAccess.close(false);
        }
    }
}

