/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.importexport.AbstractContactTest;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.importexport.formats.Format;
import com.openexchange.importexport.importers.ICalImporter;
import com.openexchange.test.AjaxInit;
import com.openexchange.tools.session.ServerSessionFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class AbstractICalImportTest
extends AbstractContactTest {
    public final Format format = Format.ICAL;
    protected static Context ctx;

    @BeforeClass
    public static void initialize() throws Exception {
        Init.startServer();
        UserStorage uStorage = UserStorage.getInstance();
        ctx = ContextStorage.getInstance().getContext(ContextStorage.getInstance().getContextId(AjaxInit.getAJAXProperty("contextName")));
        userId = uStorage.getUserId(AjaxInit.getAJAXProperty("login"), ctx);
        sessObj = ServerSessionFactory.createServerSession(userId, ctx.getContextId(), "csv-tests");
        userId = sessObj.getUserId();
        imp = new ICalImporter();
    }

    @AfterClass
    public static void shutdown() throws Exception {
        Init.stopServer();
    }

    @After
    public void cleanUpAfterTest() throws OXException {
        AbstractICalImportTest.deleteTestFolder(folderId);
    }

    public String generateRecurringICAL(int interval, String frequency) {
        return "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//The Horde Project//Horde_iCalendar Library//EN\nMETHOD:PUBLISH\nBEGIN:VEVENT\nDTSTART;VALUE=DATE:20070616\nDTEND;VALUE=DATE:20070617\nDTSTAMP:20070530T200206Z\nUID:20070530220126.23mszu01hoo0@www.klein-intern.de\nSUMMARY:Marc beim Umzug helfen\nTRANSP:OPAQUE\nORGANIZER;CN=Marcus Klein:MAILTO:m.klein@sendung-mit-der-maus.com\nLOCATION:Olpe\nRRULE:FREQ=" + frequency + ";INTERVAL=" + interval + ";UNTIL=20070627\n" + "END:VEVENT\n" + "END:VCALENDAR\n";
    }
}

